% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrunc.R, R/ptrunc.R, R/qtrunc.R, R/rtrunc.R
\name{truncatedDistribution}
\alias{truncatedDistribution}
\alias{dtrunc}
\alias{ptrunc}
\alias{qtrunc}
\alias{rtrunc}
\title{Truncated Distributions}
\usage{
dtrunc(x, distribution, tbound = c(-Inf, Inf), ..., log = FALSE)

ptrunc(q, distribution, tbound = c(-Inf, Inf), ..., lower.tail = TRUE,
  log.p = NULL)

qtrunc(p, distribution, tbound = c(-Inf, Inf), ..., lower.tail = TRUE,
  log.p = NULL)

rtrunc(n, distribution, tbound = c(-Inf, Inf), ...)
}
\arguments{
\item{x}{Vector of quantiles.}

\item{distribution}{Character value specifying the desired probability distribution.}

\item{tbound}{Numeric vector specifying the lower and upper truncation bounds. Default is \code{c(-Inf, Inf)}.}

\item{...}{Additional arguments passed to the non-truncated distribution functions.}

\item{log}{Logical; if TRUE, log densities are returned.}

\item{q}{Vector of quantiles.}

\item{lower.tail}{Logical; if TRUE (default), probabilities are P(X <= x) otherwise, P(X > x).}

\item{log.p}{Currently ignored.}

\item{p}{Vector of probabilities.}

\item{n}{A positive integer specifying the desired number of random variates.}
}
\value{
\code{dtrunc} returns a vector of densities.

\code{ptrunc} returns a vector of probabilities.

\code{qtrunc} returns a vector of quantiles.

\code{rtrunc} returns a vector of random variates.
}
\description{
Truncated probability density function, truncated cumulative density function, inverse truncated cumulative density function, and random variates from a truncated distribution.
}
\details{
The non truncated distribution functions are assumed to be available. For example if the Normal distribution is desired then used \code{distribution='norm'}, the functions then look for 'qnorm', 'pnorm', etc.

The \code{max(tbound)} and \code{min(tbound)} are considered the upper and lower truncation bounds, respectively.

The random variates are produced using the direct method (see Casella and Berger 2002).
}
\examples{

## dtrunc
# not truncted
dnorm(5,mean=5)
# truncated
dtrunc(x=5,distribution='norm',tbound=c(4,5.5),mean=5)



## ptrunc
#not truncated
pgamma(2,shape=3,rate=2)
# truncated
ptrunc(2, distribution = 'gamma', tbound=c(1,5),shape=3,rate=2)

## upper tail
# not truncated
pgamma(2,shape=3,rate=2,lower.tail=FALSE)
# truncated
ptrunc(2,distribution='gamma',tbound=c(1,5),shape=3,rate=2,lower.tail=FALSE)

## qtrunc
#not truncated
qnorm(p=.975)
# truncted
qtrunc(p=.975,distribution='norm',tbound=c(0,1))

## upper tail
# not truncted
qnorm(p=.975,lower.tail=FALSE)
# truncated
qtrunc(p=.975,distribution='norm',tbound=c(0,1),lower.tail=FALSE)

## rtrunc
rtrunc(n=5, distribution = 'gamma', tbound=c(2,5),shape=3,rate=2)
}
\references{
G. Casella and R. L. Berger. Statistical inference. Vol. 2. Duxbury Pacific Grove, CA, 2002.
}
