% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cloud.R
\name{plot_cloud}
\alias{plot_cloud}
\title{Plot outputs of all generations with standard deviations}
\usage{
plot_cloud(result, pl = FALSE)
}
\arguments{
\item{result}{The output of \code{\link{windfarmGA}} or
\code{\link{genetic_algorithm}}}

\item{pl}{Should the results be plotted? Default is FALSE}
}
\value{
Returns a data.frame with the values for fitness, efficiency and
  energy for all evaluated individuals
}
\description{
Plot the fitness, efficiency and energy outputs of all
  generations and the corresponding standard deviations.
}
\examples{
\donttest{
## Add some data examples from the package
load(file = system.file("extdata/resulthex.rda", package = "windfarmGA"))

## Plot the results of a hexagonal grid optimization
plcdf <- plot_cloud(resulthex, TRUE)
}
}
\seealso{
Other Plotting Functions: 
\code{\link{interpol_view}()},
\code{\link{plot_development}()},
\code{\link{plot_evolution}()},
\code{\link{plot_fitness_evolution}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_parkfitness}()},
\code{\link{plot_result}()},
\code{\link{plot_viewshed}()},
\code{\link{plot_windfarmGA}()},
\code{\link{plot_windrose}()},
\code{\link{random_search_single}()}
}
\concept{Plotting Functions}
