% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visibility.R
\name{plot_viewshed}
\alias{plot_viewshed}
\title{Plot visibility}
\usage{
plot_viewshed(r, turbine_locs, h1 = 0, h2 = 0, plot = TRUE, ...)
}
\arguments{
\item{r}{The elevation SpatRaster}

\item{turbine_locs}{Coordinates, SpatialPoint or SimpleFeature Points
representing the wind turbines}

\item{h1}{A single number or numeric vector giving the extra height offsets
for the \code{turbine_locs}}

\item{h2}{The height offset for Point 2}

\item{plot}{Should the result be plotted. Default is \code{TRUE}}

\item{...}{forwarded to \code{terra::plot}}
}
\value{
A mosaiced SpatRaster, representing the visibility for all \code{turbine_locs}
}
\description{
Calculate and plot visibility for given points in a given area.
}
\examples{
\donttest{
library(sf)
library(terra)

f <- system.file("ex/elev.tif", package = "terra")
r <- rast(f)
x <- project(r, "EPSG:2169")
shape <- sf::st_as_sf(as.polygons(terra::boundaries(x)))
plot(shape)
st_crs(shape) <- 2169
locs <- st_sample(shape, 10, type = "random")
plot_viewshed(x, locs, h1 = 0, h2 = 0, plot = TRUE)
}
}
\concept{Viewshed Analysis}
