% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview_gd.R
\name{preview_gd}
\alias{preview_gd}
\title{Preview moving window and sample counts}
\usage{
preview_gd(
  lyr,
  coords,
  method = "window",
  wdim = 3,
  maxdist = NULL,
  distmat = NULL,
  fact = 0,
  sample_count = TRUE,
  min_n = 0,
  plot = TRUE
)
}
\arguments{
\item{lyr}{SpatRaster or RasterLayer to slide the window across (see Details for important information about projections). For \code{method = "resist"} this should also be the conductivity layer (see \link[wingen]{resist_gd})}

\item{coords}{coordinates of samples as sf points, a two-column matrix, or a data.frame representing x and y coordinates (see Details for important information about projections)}

\item{method}{which method to use to create preview (\code{"window"} for \link[wingen]{window_gd}, \code{"circle"} for \link[wingen]{circle_gd}, or \code{"resist"} for \link[wingen]{resist_gd}; defaults to \code{"window"})}

\item{wdim}{if \code{method = "window"}, dimensions (height x width) of window; if only one value is provided, a square window is created (defaults to 3 x 3 window)}

\item{maxdist}{if \code{method = "circle"} or \verb{method = "resist}, the maximum geographic distance used to define the neighborhood; any samples further than this distance will not be included (see \link[wingen]{get_geodist} or \link[wingen]{get_resdist})}

\item{distmat}{if \code{method = "circle"} or \code{method = "resist"}, an optional distance matrix to be used output from either \link[wingen]{get_geodist} or \link[wingen]{get_resdist}, respectively. If not provided, one will be automatically calculated.}

\item{fact}{aggregation factor to apply to \code{lyr} (defaults to 0; \emph{note:} increasing this value reduces computational time)}

\item{sample_count}{whether to create plot of sample counts for each cell (defaults to TRUE)}

\item{min_n}{minimum number of samples to use in calculations (any focal cell with a window containing less than this number of samples will be assigned a value of NA)}

\item{plot}{whether to plot results (default = TRUE)}
}
\value{
Plots preview of window and returns SpatRaster with sample counts layer (if sample_count = TRUE)
}
\description{
Generate a preview of moving window size and sample counts based on the coordinates and
parameters to be supplied to \link[wingen]{window_gd}, \link[wingen]{circle_gd}, or  \link[wingen]{resist_gd}.
The method to be used should be specified with \code{method = "window"}, \code{"circle"}, or \code{"resist"}. For \code{method = "window"},
\code{wdim} must be specified. For \code{method = "circle"} or \code{"resist"}, \code{maxdist} must be specified and
\code{distmat} can also optionally be specified.
}
\details{
Coordinates and rasters should be in a projected (planar) coordinate system such that raster cells are of equal sizes.
Therefore, spherical systems (including latitute-longitude coordinate systems) should be projected prior to use.
Transformation can be performed using \link[sf]{st_set_crs} for coordinates or \link[terra]{project} for rasters (see vignette for more details).
}
\examples{
load_mini_ex()
preview_gd(mini_lyr, mini_coords, wdim = 3, fact = 3, sample_count = TRUE, min_n = 2)
}
