% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iwishmom.R
\name{iwishmom}
\alias{iwishmom}
\title{Expectation of a Matrix-valued Function of an Inverse beta-Wishart Distribution}
\usage{
iwishmom(n, S, f, iw = 0, alpha = 2)
}
\arguments{
\item{n}{The degrees of freedom of the beta-Wishart matrix \eqn{W}}

\item{S}{The covariance matrix of the beta-Wishart matrix \eqn{W}}

\item{f}{A vector of nonnegative integers \eqn{f_j} that represents
the power of \eqn{\mbox{tr}(W^{-j})}, where \eqn{j=1, \ldots, r}}

\item{iw}{The power of the inverse beta-Wishart matrix \eqn{W^{-1}} (0 by default)}

\item{alpha}{The type of Wishart distribution \eqn{(\alpha=2/\beta)}:
\itemize{
\item 1/2: Quaternion Wishart
\item 1: Complex Wishart
\item 2: Real Wishart (default)
}}
}
\value{
When \code{iw = 0}, it returns \eqn{E[\prod_{j=1}^r \mbox{tr}(W^{-j})^{f_j}]}.
When \code{iw != 0}, it returns \eqn{E[\prod_{j=1}^r \mbox{tr}(W^{-j})^{f_j}W^{-iw}]}.
}
\description{
When \code{iw = 0}, the function calculates \eqn{E[\prod_{j=1}^r \mbox{tr}(W^{-j})^{f_j}]},
where \eqn{W \sim W_m^{\beta}(n, S)}.  When \code{iw != 0},
the function calculates \eqn{E[\prod_{j=1}^r \mbox{tr}(W^{-j})^{f_j}W^{-iw}]}.
}
\examples{
# Example 1: For E[tr(W^{-1})^2] with W ~ W_m^1(n,S),
# where n and S are defined below:
n <- 20
S <- matrix(c(25, 49,
              49, 109), nrow=2, ncol=2)
iwishmom(n, S, 2) # iw = 0, for real Wishart distribution

# Example 2: For E[tr(W^{-1})^2*tr(W^{-3})W^{-2}] with W ~ W_m^1(n,S),
# where n and S are defined below:
n <- 20
S <- matrix(c(25, 49,
              49, 109), nrow=2, ncol=2)
iwishmom(n, S, c(2, 0, 1), 2, 2) # for real Wishart distribution

# Example 3: For E[tr(W^{-1})^2*tr(W^{-3})] with W ~ W_m^2(n,S),
# where n and S are defined below:
# Hermitian S for the complex case
n <- 20
S <- matrix(c(25, 49 + 2i,
              49 - 2i, 109), nrow=2, ncol=2)
iwishmom(n, S, c(2, 0, 1), 0, 1) # iw = 0, for complex Wishart distribution

# Example 4: For E[tr(W^{-1})*tr(W^{-2})^2*tr(W^{-3})^2*W^{-1}] with W ~ W_m^2(n,S),
# where n and S are defined below:
n <- 30
S <- matrix(c(25, 49 + 2i,
              49 - 2i, 109), nrow=2, ncol=2)
iwishmom(n, S, c(1, 2, 2), 1, 1) # for complex Wishart distribution
}
