% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRedcap.R
\name{redcap}
\alias{redcap}
\title{Fetch data from REDCap to be stored in a data frame}
\usage{
redcap(
  instrument_name = NULL,
  raw_or_label = "raw",
  redcap_event_name = NULL,
  batch_size = 1000,
  records = NULL,
  fields = NULL,
  exclude_pii = TRUE,
  interview_date = NULL,
  date_format = "ymd"
)
}
\arguments{
\item{instrument_name}{Name of the REDCap instrument}

\item{raw_or_label}{Whether to return raw or labeled values}

\item{redcap_event_name}{Optional event name filter}

\item{batch_size}{Number of records to retrieve per batch}

\item{records}{Optional vector of specific record IDs}

\item{fields}{Optional vector of specific fields}

\item{exclude_pii}{Default TRUE remove all fields marked as identifiable}

\item{interview_date}{Optional; can be either:
- A date string in various formats (ISO, US, etc.) to filter data up to that date
- A boolean TRUE to return only rows with non-NA interview_date values}

\item{date_format}{Default ymd define date format for interview_date}
}
\value{
A data frame containing the requested REDCap data
}
\description{
Retrieves data from a REDCap instrument and ensures subject identifiers
are propagated across all events
}
\examples{
\dontrun{
# Get data from a specific instrument
data <- redcap("demographics")
}
}
