% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{wkb_draw_points}
\alias{wkb_draw_points}
\alias{wkt_draw_points}
\alias{wksxp_draw_points}
\alias{wkb_draw_lines}
\alias{wkt_draw_lines}
\alias{wksxp_draw_lines}
\alias{wkb_draw_polypath}
\alias{wkt_draw_polypath}
\alias{wksxp_draw_polypath}
\alias{wkb_plot_new}
\alias{wkt_plot_new}
\alias{wksxp_plot_new}
\title{Draw well-known geometries}
\usage{
wkb_draw_points(wkb, ...)

wkt_draw_points(wkt, ...)

wksxp_draw_points(wksxp, ...)

wkb_draw_lines(wkb, ...)

wkt_draw_lines(wkt, ...)

wksxp_draw_lines(wksxp, ...)

wkb_draw_polypath(wkb, ..., rule = "evenodd")

wkt_draw_polypath(wkt, ..., rule = "evenodd")

wksxp_draw_polypath(wksxp, ..., rule = "evenodd")

wkb_plot_new(
  wkb,
  ...,
  asp = 1,
  xlab = "",
  ylab = "",
  main = deparse(substitute(wkb))
)

wkt_plot_new(
  wkt,
  ...,
  asp = 1,
  xlab = "",
  ylab = "",
  main = deparse(substitute(wkt))
)

wksxp_plot_new(
  wksxp,
  ...,
  asp = 1,
  xlab = "",
  ylab = "",
  main = deparse(substitute(wksxp))
)
}
\arguments{
\item{wkb}{A \code{list()} of \code{\link[=raw]{raw()}} vectors, such as that
returned by \code{\link[sf:st_as_binary]{sf::st_as_binary()}}.}

\item{...}{Passed to \code{\link[graphics:points]{graphics::points()}},
\code{\link[graphics:lines]{graphics::lines()}}, or \code{\link[graphics:polypath]{graphics::polypath()}}}

\item{wkt}{A character vector containing well-known text.}

\item{wksxp}{A \code{list()} of classed objects}

\item{rule}{Passed to \code{\link[graphics:polypath]{graphics::polypath()}}}

\item{asp, xlab, ylab, main}{Passed to \code{\link[graphics:plot.default]{graphics::plot()}} to
initialize a new plot.}
}
\value{
The input, invisibly
}
\description{
These functions send well-known geometry vectors to a
graphics device using \code{\link[graphics:points]{graphics::points()}},
\code{\link[graphics:lines]{graphics::lines()}}, and \code{\link[graphics:polypath]{graphics::polypath()}}. These are
minimal wrappers aimed at developers who need to visualize
test data: they do not check geometry type and are unlikely
to work with vectorized graphical parameters in \code{...}. Use
the \verb{wk*_plot_new()} functions to initialize a plot using the
extent of all coordinates in the vector.
}
\examples{
x <- "POLYGON ((0 0, 10 0, 10 10, 0 10, 0 0))"

wkt_plot_new(x)
wkt_draw_polypath(x, col = "grey90")
wkt_draw_lines(x, col = "red")
wkt_draw_points(x)

}
