% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_legendre.R
\name{.CalculateRecursiveLegendre}
\alias{.CalculateRecursiveLegendre}
\title{Run recursion to compute associated Legendre functions}
\usage{
.CalculateRecursiveLegendre(n, m, mu, index, Pn_1 = NULL, Pn_2 = NULL,
  Pm_1 = NULL, Pm_2 = NULL)
}
\arguments{
\item{n}{Degree of associated Legendre function to compute}

\item{m}{Order of associated Legendre function to compute}

\item{mu}{Argument of associated Legendre function to compute}

\item{index}{Index from \code{.kLegendreIndices} associated with \code{n} and \code{m}}

\item{Pn_1}{\eqn{P_{n-1,m}(\mu)}{P_{n-1,m}(mu)}}

\item{Pn_2}{\eqn{P_{n-2,m}(\mu)}{P_{n-2,m}(mu)}}

\item{Pm_1}{\eqn{P_{n,m-1}(\mu)}{P_{n,m-1}(mu)}}

\item{Pm_2}{\eqn{P_{n,m-2}(\mu)}{P_{n,m-2}(mu)}}
}
\value{
\eqn{P_{n,m}(\mu)}{P_{n,m}(mu)}, scalar
}
\description{
Use recursion relations to compute the associated Legendre function, \eqn{P_{n,m}(\mu)}{P_{n,m}(mu)}. User supplies degree \eqn{n} and order \eqn{m} as well as associated Legendre functions with smaller degree and order indices for recursion.
When \eqn{n \leq 2}{n <= 2}, \eqn{P_{n,m}(\mu)}{P_{n,m}(mu)} is directly calculated with known functions (i.e., no recursion). When \eqn{n > 2}, the following recursion relations are used based on the order \eqn{m}:
\deqn{P_{n > 2, m \leq 1}(\mu) = \frac{(2n - 1) \cdot \mu \cdot P_{n-1,m}(\mu) - (n - 1 + m) \cdot P_{n-2,m}(\mu)}{(n - m)}}{P_{n > 2, m <= 1}(mu) = ((2 * n - 1) * mu * Pn_1 - (n - 1 + m) * Pn_2) / (n - m)}
\deqn{P_{n > 2, m > 1}(\mu) = \frac{2\mu(m - 1) \cdot P_{n,m-1}(\mu)}{\sqrt{1 - \mu^2}} - (n + m - 1) \cdot (n - m + 2) \cdot P_{n,m-2}(\mu)}{P_{n > 2, m > 1}(mu) = 2 * mu * (m - 1) * Pm_1 / sqrt(1 - mu^2) - (n + m - 1) * (n - m + 2) * Pm_2}
}
