% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github-latest.R
\name{wood_github_latest}
\alias{wood_github_latest}
\title{Get current package version on GitHub}
\usage{
wood_github_latest(package, user)
}
\arguments{
\item{package}{\code{character(1)}\cr
Name of a package to query for.}

\item{user}{\code{character(1)}\cr
Name of a user or organization.}
}
\value{
A character vector of version codes.
}
\description{
This function queries GitHub for the code of the current package
versions. This may reference a non-tagged commit; for the analysis of tagged
commits only, see \code{\link[=wood_github_versions]{wood_github_versions()}}.
}
\examples{
\donttest{
# Latest version code is returned
wood_github_latest("gglgbtq", "turtletopia")

# To get the latest *tagged* version code instead, use:
codes <- wood_github_versions("gglgbtq", "turtletopia")
versionsort::ver_latest(codes)
}

}
\seealso{
Functions for GitHub:
\code{\link{wood_github_dependencies}()},
\code{\link{wood_github_packages}()},
\code{\link{wood_github_tags}()},
\code{\link{wood_github_versions}()}

Functions that query package versions:
\code{\link{wood_bioc_version}()},
\code{\link{wood_core_version}()},
\code{\link{wood_cran_latest}()},
\code{\link{wood_cran_versions}()},
\code{\link{wood_github_versions}()},
\code{\link{wood_local_versions}()},
\code{\link{wood_runiverse_version}()},
\code{\link{wood_url_version}()},
\code{\link{wood_versions}()}
}
\concept{github}
\concept{versions}
