% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github-tags.R
\name{wood_github_tags}
\alias{wood_github_tags}
\title{List GitHub tags for a repository}
\usage{
wood_github_tags(package, user)
}
\arguments{
\item{package}{\code{character(1)}\cr
Name of a package to query for.}

\item{user}{\code{character(1)}\cr
Name of a user or organization.}
}
\value{
A character vector of repository tags.
}
\description{
This function queries GitHub for a list of tags for a given
repository (indicated by a combination of package name and username). Each
element is a tag, which need not be identical or even related to version code
of the package at the given time.
}
\examples{
\donttest{
wood_github_tags("gglgbtq", "turtletopia")
# Sometimes there are no tags (yet?)
wood_github_tags("ggpizza", "turtletopia")
}

}
\seealso{
Functions for GitHub:
\code{\link{wood_github_dependencies}()},
\code{\link{wood_github_latest}()},
\code{\link{wood_github_packages}()},
\code{\link{wood_github_versions}()}
}
\concept{github}
