% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url-version.R
\name{wood_url_version}
\alias{wood_url_version}
\title{Get current package version in any repository}
\usage{
wood_url_version(package, repository)
}
\arguments{
\item{package}{\code{character(1)}\cr
Name of a package to query for.}

\item{repository}{\code{character(1)}\cr
URL to repository, e.g. \code{"http://www.omegahat.net/R"}.}
}
\value{
A single string with a version code.
}
\description{
This function queries any online repository for the code of the
current version of the selected package.
}
\examples{
\donttest{
wood_url_version("XML", repository = "http://www.omegahat.net/R")
}

}
\seealso{
Functions for any URL:
\code{\link{wood_url_dependencies}()},
\code{\link{wood_url_packages}()}

Functions that query package versions:
\code{\link{wood_bioc_version}()},
\code{\link{wood_core_version}()},
\code{\link{wood_cran_latest}()},
\code{\link{wood_cran_versions}()},
\code{\link{wood_github_latest}()},
\code{\link{wood_github_versions}()},
\code{\link{wood_local_versions}()},
\code{\link{wood_runiverse_version}()},
\code{\link{wood_versions}()}
}
\concept{url}
\concept{versions}
