% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint.R
\name{snapshot_endpoints}
\alias{snapshot_endpoints}
\title{Snapshot endpoints in WORCS project}
\usage{
snapshot_endpoints(worcs_directory = ".", verbose = TRUE, ...)
}
\arguments{
\item{worcs_directory}{Character, indicating the WORCS project directory
to which to save data. The default value "." points to the current directory.
Default: '.'}

\item{verbose}{Logical. Whether or not to print status messages to the
console. Default: TRUE}

\item{...}{Additional arguments.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
Update the checksums of all endpoints in a WORCS project.
}
\examples{
# Create directory to run the example
old_wd <- getwd()
test_dir <- file.path(tempdir(), "update_endpoint")
dir.create(test_dir)
setwd(test_dir)
file.create(".worcs")
writeLines("test", "test.txt")
add_endpoint("test.txt")
writeLines("second test", "test.txt")
snapshot_endpoints()
# Cleaning example directory
setwd(old_wd)
unlink(test_dir, recursive = TRUE)
}
\seealso{
\code{\link[worcs]{add_endpoint}}
\code{\link[worcs]{check_endpoints}}
}
