% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word2vec.R
\name{read.word2vec}
\alias{read.word2vec}
\title{Read a binary word2vec model from disk}
\usage{
read.word2vec(file)
}
\arguments{
\item{file}{the path to the model file}
}
\value{
an object of class w2v which is a list with elements
\itemize{
\item{model: a Rcpp pointer to the model}
\item{model_path: the path to the model on disk}
\item{dim: the dimension of the embedding matrix}
\item{n: the number of words in the vocabulary}
}
}
\description{
Read a binary word2vec model from disk
}
\examples{
path  <- system.file(package = "word2vec", "models", "example.bin")
model <- read.word2vec(path)
vocab <- summary(model, type = "vocabulary")
emb <- predict(model, c("bus", "naar", "unknownword"), type = "embedding")
emb
nn  <- predict(model, c("bus", "toilet"), type = "nearest")
nn
}
