/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone;

import com.nexagis.jawbone.FrameData;
import com.nexagis.jawbone.ParseDataFile;
import com.nexagis.jawbone.PartOfSpeech;
import com.nexagis.jawbone.Pointer;
import com.nexagis.jawbone.Utility;
import com.nexagis.jawbone.WordData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Synset {
    private long synsetOffset = 0L;
    private int lexFilenum = 0;
    private PartOfSpeech pos;
    private int numWords = 0;
    private List<WordData> listWords = null;
    private int pointerCount = 0;
    private List<Pointer> listPointers = null;
    private int frameCount = 0;
    private List<FrameData> listFrames = null;
    private String gloss;
    private boolean loaded = false;

    protected Synset() {
    }

    protected Synset(long l, PartOfSpeech partOfSpeech) {
        this.synsetOffset = l;
        this.pos = partOfSpeech;
    }

    public String getGloss() {
        this.checkLoad();
        return this.gloss;
    }

    protected void setGloss(String string) {
        this.gloss = string;
    }

    public int getLexFilenum() {
        this.checkLoad();
        return this.lexFilenum;
    }

    protected void setLexFilenum(int n) {
        this.lexFilenum = n;
    }

    public int getNumWords() {
        this.checkLoad();
        return this.numWords;
    }

    protected void setNumWords(int n) {
        this.numWords = n;
        if (this.numWords > 0 && this.listWords == null) {
            this.listWords = new ArrayList<WordData>(this.numWords);
        }
    }

    public int getPointerCount() {
        this.checkLoad();
        return this.pointerCount;
    }

    protected void setPointerCount(int n) {
        this.pointerCount = n;
        if (this.pointerCount > 0 && this.listPointers == null) {
            this.listPointers = new ArrayList<Pointer>(this.pointerCount);
        }
    }

    public List<Pointer> getPointers() {
        this.checkLoad();
        return this.listPointers;
    }

    public long get9DigitID() {
        return (long)(this.getPOS().getPrefix() * 100000000) + this.getSynsetOffset();
    }

    public List<Synset> getRelatedSynsets(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        ArrayList<Synset> arrayList = new ArrayList<Synset>();
        List<Pointer> list = this.getPointers();
        for (int i = 0; i < list.size(); ++i) {
            Pointer pointer = list.get(i);
            if (!pointer.getPointerSymbol().equals(string)) continue;
            arrayList.add(pointer.getSynset());
        }
        return arrayList == null || arrayList.isEmpty() ? null : arrayList;
    }

    protected void addPointer(Pointer pointer) {
        if (this.listPointers == null) {
            this.listPointers = new ArrayList<Pointer>(5);
        }
        this.listPointers.add(pointer);
    }

    public PartOfSpeech getPOS() {
        this.checkLoad();
        return this.pos;
    }

    protected void setPosType(char c) {
        this.pos = PartOfSpeech.getInstance(c);
    }

    public long getSynsetOffset() {
        return this.synsetOffset;
    }

    protected void setSynsetOffset(long l) {
        this.synsetOffset = l;
    }

    public List<WordData> getWord() {
        this.checkLoad();
        return this.listWords;
    }

    protected void addWord(WordData wordData) {
        if (this.listWords == null) {
            this.listWords = new ArrayList<WordData>(3);
        }
        this.listWords.add(wordData);
    }

    public int getFrameCount() {
        this.checkLoad();
        return this.frameCount;
    }

    protected void setFrameCount(int n) {
        this.frameCount = n;
        if (this.frameCount > 0 && this.listFrames == null) {
            this.listFrames = new ArrayList<FrameData>(this.frameCount);
        }
    }

    public List<FrameData> getFrames() {
        this.checkLoad();
        return this.listFrames;
    }

    protected void addFrame(FrameData frameData) {
        if (this.listFrames == null) {
            this.listFrames = new ArrayList<FrameData>(5);
        }
        this.listFrames.add(frameData);
    }

    public String toString() {
        this.checkLoad();
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("Synset-Offset: ").append(this.synsetOffset).append("  Lex-FileNum: ").append(this.lexFilenum).append("  POS: ").append(this.pos).append("  Num-Words: ").append(this.numWords).append("\nNum-Ptrs: ").append(this.pointerCount).append("  Num-Frames: ").append(this.frameCount).append("\nGloss: ").append(this.gloss);
        int n = 0;
        if (this.listWords == null) {
            stringBuffer.append("\nList-Words: (null)");
        } else {
            stringBuffer.append("\nList of Words (").append(this.numWords).append(")");
            for (WordData object : this.listWords) {
                stringBuffer.append("\n  #").append(n + 1).append(": ").append(object.toString());
                ++n;
            }
        }
        n = 0;
        if (this.listPointers == null) {
            stringBuffer.append("\nList-Pointers: (null)");
        } else {
            stringBuffer.append("\nList of Pointers (").append(this.pointerCount).append(")");
            for (Pointer pointer : this.listPointers) {
                stringBuffer.append("\n  #").append(n + 1).append(": ").append(pointer.toString());
                ++n;
            }
        }
        n = 0;
        if (this.listFrames == null) {
            stringBuffer.append("\nList-Frames: (no frames)");
        } else {
            stringBuffer.append("\nList of Frames (").append(this.frameCount).append(")");
            for (FrameData frameData : this.listFrames) {
                stringBuffer.append("\n  #").append(n + 1).append(": ").append(frameData.toString());
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Synset)) {
            return false;
        }
        Synset synset = (Synset)object;
        return this.getPOS().equals(synset.getPOS()) && this.getSynsetOffset() == synset.getSynsetOffset() && this.getLexFilenum() == synset.getLexFilenum();
    }

    private void checkLoad() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        if (this.pos == null || this.synsetOffset <= 0L) {
            return;
        }
        String string = Utility.getFilename(this.pos, false);
        if (string == null || string.length() < 1) {
            return;
        }
        File file = new File(string);
        boolean bl = file.exists();
        if (!bl) {
            return;
        }
        if (!file.isFile()) {
            return;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            randomAccessFile.seek(this.synsetOffset);
            String string2 = randomAccessFile.readLine();
            ParseDataFile.process(string2, this);
            randomAccessFile.close();
            randomAccessFile = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found exception: " + fileNotFoundException.getMessage());
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            System.err.println("IO exception: " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }
}

