% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre-action-formula.R
\name{add_formula}
\alias{add_formula}
\alias{remove_formula}
\alias{update_formula}
\title{Add formula terms to a workflow}
\usage{
add_formula(x, formula, ..., blueprint = NULL)

remove_formula(x)

update_formula(x, formula, ..., blueprint = NULL)
}
\arguments{
\item{x}{A workflow}

\item{formula}{A formula specifying the terms of the model. It is advised to
not do preprocessing in the formula, and instead use a recipe if that is
required.}

\item{...}{Not used.}

\item{blueprint}{A hardhat blueprint used for fine tuning the preprocessing.
If \code{NULL}, \code{\link[hardhat:default_formula_blueprint]{hardhat::default_formula_blueprint()}} is used.}
}
\value{
\code{x}, updated with either a new or removed formula preprocessor.
}
\description{
\itemize{
\item \code{add_formula()} specifies the terms of the model through the usage of a
formula.
\item \code{remove_formula()} removes the formula as well as any downstream objects
that might get created after the formula is used for preprocessing, such as
terms. Additionally, if the model has already been fit, then the fit is
removed.
\item \code{update_formula()} first removes the formula, then replaces the previous
formula with the new one. Any model that has already been fit based on this
formula will need to be refit.
}
}
\details{
To fit a workflow, one of \code{add_formula()} or \code{add_recipe()} \emph{must} be
specified, but not both.
}
\examples{
workflow <- workflow()
workflow <- add_formula(workflow, mpg ~ cyl)
workflow

remove_formula(workflow)

update_formula(workflow, mpg ~ disp)
}
