% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-action-model.R
\name{add_model}
\alias{add_model}
\alias{remove_model}
\alias{update_model}
\title{Add a model to a workflow}
\usage{
add_model(x, spec, formula = NULL)

remove_model(x)

update_model(x, spec, formula = NULL)
}
\arguments{
\item{x}{A workflow.}

\item{spec}{A parsnip model specification.}

\item{formula}{An optional formula override to specify the terms of the
model. Typically, the terms are extracted from the formula or recipe
preprocessing methods. However, some models (like survival and bayesian
models) use the formula not to preprocess, but to specify the structure
of the model. In those cases, a formula specifying the model structure
must be passed unchanged into the model call itself. This argument is
used for those purposes.}
}
\value{
\code{x}, updated with either a new or removed model.
}
\description{
\itemize{
\item \code{add_model()} adds a parsnip model to the workflow.
\item \code{remove_model()} removes the model specification as well as any fitted
model object. Any extra formulas are also removed.
\item \code{update_model()} first removes the model then adds the new specification to
the workflow.
}
}
\details{
\code{add_model()} is a required step to construct a minimal workflow.
}
\examples{
library(parsnip)

lm_model <- linear_reg()
lm_model <- set_engine(lm_model, "lm")

regularized_model <- set_engine(lm_model, "glmnet")

workflow <- workflow()
workflow <- add_model(workflow, lm_model)
workflow

workflow <- add_formula(workflow, mpg ~ .)
workflow

remove_model(workflow)

fitted <- fit(workflow, data = mtcars)
fitted

remove_model(fitted)

remove_model(workflow)

update_model(workflow, regularized_model)
update_model(fitted, regularized_model)

}
