% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{fit-workflow}
\alias{fit-workflow}
\alias{fit.workflow}
\title{Fit a workflow object}
\usage{
\method{fit}{workflow}(object, data, ..., control = control_workflow())
}
\arguments{
\item{object}{A workflow}

\item{data}{A data frame of predictors and outcomes to use when fitting the
workflow}

\item{...}{Not used}

\item{control}{A \code{\link[=control_workflow]{control_workflow()}} object}
}
\value{
The workflow \code{object}, updated with a fit parsnip model in the
\code{object$fit$fit} slot.
}
\description{
Fitting a workflow currently involves two main steps:
\itemize{
\item Preprocessing the data using a formula preprocessor, or by calling
\code{\link[recipes:prep]{recipes::prep()}} on a recipe.
\item Fitting the underlying parsnip model using \code{\link[parsnip:fit.model_spec]{parsnip::fit.model_spec()}}.
}
}
\details{
In the future, there will also be \emph{postprocessing} steps that can be added
after the model has been fit.
}
\examples{
library(parsnip)
library(recipes)

model <- linear_reg()
model <- set_engine(model, "lm")

base_workflow <- workflow()
base_workflow <- add_model(base_workflow, model)

formula_workflow <- add_formula(base_workflow, mpg ~ cyl + log(disp))

fit(formula_workflow, mtcars)

recipe <- recipe(mpg ~ cyl + disp, mtcars)
recipe <- step_log(recipe, disp)

recipe_workflow <- add_recipe(base_workflow, recipe)

fit(recipe_workflow, mtcars)
}
