% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subject_classify.R
\name{subject_classify}
\alias{subject_classify}
\title{Create a new logical variable that classifies meetings by patterns in
subject lines}
\usage{
subject_classify(
  data,
  var_name = "class",
  keywords = NULL,
  pattern = NULL,
  ignore_case = FALSE,
  return = "data"
)
}
\arguments{
\item{data}{A Meeting Query dataset in the form of a data frame.}

\item{var_name}{String containing the name of the new column to be created.}

\item{keywords}{Character vector containing the keywords to match.}

\item{pattern}{String to use for regular expression matching instead of
\code{keywords}. When both \code{keywords} and \code{pattern} are supplied, \code{pattern}
takes priority and is used instead.}

\item{ignore_case}{Logical value to determine whether to ignore case when
performing pattern matching.}

\item{return}{String specifying what output to return.}
}
\description{
Take a meeting query with subject lines and create a new
TRUE/FALSE column which classifies meetings by a provided set of patterns in
the subject lines.
}
\examples{
class_df <-
  mt_data \%>\%
  subject_classify(
    var_name = "IsSales",
    keywords = c("sales", "marketing")
  )

class_df \%>\% dplyr::count(IsSales)

# Return a table directly
mt_data \%>\% subject_classify(pattern = "annual", return = "table")

}
