% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_IV.R
\name{map_IV}
\alias{map_IV}
\title{Calculate Weight of Evidence (WOE) and Information Value (IV) between
multiple predictors and a single outcome variable, returning a list of
statistics.}
\usage{
map_IV(data, predictors = NULL, outcome, bins = 10)
}
\arguments{
\item{data}{Data frame containing the data.}

\item{predictors}{Character vector containing the names of the predictor
variables. If \code{NULL} (default) is supplied, all numeric variables in the
data will be used.}

\item{outcome}{String containing the name of the outcome variable.}

\item{bins}{Numeric value representing the number of bins to use. Defaults to
10.}
}
\value{
A list of data frames is returned as an output. The first layer of
the list contains \code{Tables} and \code{Summary}:
\itemize{
\item \code{Tables} is a list of data frames containing the WOE and cumulative sum
IV for each predictor.
\item \code{Summary} is a single data frame containing the IV for all predictors.
}
}
\description{
This is a wrapper around \code{calculate_IV()} to loop through multiple predictors
and calculate their Weight of Evidence (WOE) and Information Value (IV) with
respect to an outcome variable.
}
\details{
The approach used mirrors the one used in \code{Information::create_infotables()}.
}
