% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hourly_pat.R
\name{plot_hourly_pat}
\alias{plot_hourly_pat}
\title{Internal function for plotting the hourly activity patterns.}
\usage{
plot_hourly_pat(
  data,
  start_hour,
  end_hour,
  legend,
  legend_label,
  legend_text = "Observed activity",
  rows,
  title,
  subtitle,
  caption,
  ylab = paste("Top", rows, "activity patterns")
)
}
\arguments{
\item{data}{Data frame containing three columns:
\itemize{
\item \code{patternRank}
\item \code{Hours}
\item \code{Freq}
}}

\item{start_hour}{Numeric value to specify expected start hour.}

\item{end_hour}{Numeric value to specify expected end hour.}

\item{legend}{Data frame containing the columns:
\itemize{
\item \code{patternRank}
\item Any column to be used in the grey label box, supplied to \code{legend_label}
}}

\item{legend_label}{String specifying column to display in the grey label
box}

\item{legend_text}{String to be used in the bottom legend label.}

\item{rows}{Number of rows to show in plot.}

\item{title}{String to specify plot title.}

\item{subtitle}{String to specify plot subtitle.}

\item{caption}{String to specify plot caption.}

\item{ylab}{String to specify plot y-axis label.}
}
\description{
This is used within \code{plot_flex_index()} and \code{workpatterns_rank()}.
}
