% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countCloseToLimits.R
\name{countCloseToLimits}
\alias{countCloseToLimits}
\title{Count from two vectors number of values close within given limits}
\usage{
countCloseToLimits(closeMatch, limitIdent = 5, prefix = "lim_")
}
\arguments{
\item{closeMatch}{(list) output from findCloseMatch(), ie list indicating which instances of 2 series of data have close matches}

\item{limitIdent}{(numeric) max limit or panel of threshold values to test (if single value, in addtion a panel with values below will be tested)}

\item{prefix}{(character)  prefix for names of output}
}
\value{
integer vector with counts for number of list-elements with at least one absolue value below threshold, names
}
\description{
This functions summarizes the serach of similar (or identical) numeric values from 2 initial vectors, it 
evaluates the result from initial search run by findCloseMatch(), whose output is a less convenient list.
\code{countCloseToLimits} checks furthermore how many results within additional (more stringent)
distance-limits may be found and returns the number of distance values within the limits tested.
Designed for checking if threshold used with findCloseMatch() may be set more stringent, eg  when searching reasonable FDR limits ...
}
\examples{
set.seed(2019); aa <- sample(12:15,20,repl=TRUE) +round(runif(20),2)-0.5
bb <- 11:18
match1 <- findCloseMatch(aa,bb,com="diff",lim=0.65)
head(match1)
(tmp3 <- countCloseToLimits(match1,lim=c(0.5,0.35,0.2)))
(tmp4 <- countCloseToLimits(match1,lim=0.7))
}
\seealso{
\code{\link[wrMisc]{findCloseMatch}}
}
