% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterNetw.R
\name{filterNetw}
\alias{filterNetw}
\title{Filter nodes & edges for extracting networks
 
This function allows extracting and filtering network-data based on fixed threshold (\code{limInt}) and add sandwich-nodes (nodes inter-connecting initial nodes) out of node-based queries.}
\usage{
filterNetw(
  lst,
  filtCol = 3,
  limInt = 5000,
  sandwLim = 5000,
  filterAsInf = TRUE,
  outFormat = "matrix",
  remOrphans = TRUE,
  remRevPairs = TRUE,
  reverseCheck = TRUE,
  elemNa = "genes",
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{lst}{(list, composed of multiple matrix or data.frames ) main input (each list-element should have same number of columns)}

\item{filtCol}{(integer, length=1) which column of \code{lst} should be usd to filter using thresholds \code{limInt} and \code{sandwLim}}

\item{limInt}{(numeric, length=1) filter main edge-scores according to \code{filterAsInf}}

\item{sandwLim}{(numeric, length=1) filter sandwich connection edge-scores accodring to \code{filterAsInf}}

\item{filterAsInf}{(logical) filter as 'inferior or equal' or 'superior or equal'}

\item{outFormat}{(character) may be 'matrix' for tabular output, 'all' as list with matrix and list of node-names}

\item{remOrphans}{(logical) remove networks consisting only of 2 connected edges}

\item{remRevPairs}{(logical) remove duplicate edges due to reverse massping (eg A - B and B - A); NOTE : use only when edges don't have orientation !}

\item{reverseCheck}{(logical) depreciated}

\item{elemNa}{(character) used only for messages}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}

\item{debug}{(logical) display additional messages for debugging}
}
\value{
This function returns a matrix or data.frame
}
\description{
Filter nodes & edges for extracting networks
 
This function allows extracting and filtering network-data based on fixed threshold (\code{limInt}) and add sandwich-nodes (nodes inter-connecting initial nodes) out of node-based queries.
}
\examples{

lst2 <- list('121'=data.frame(ID=as.character(c(141,221,228,229,449)),11:15), 
	 '131'=data.frame(ID=as.character(c(228,331,332,333,339)),11:15), 
  '141'=data.frame(ID=as.character(c(121,151,229,339,441,442,449)),c(11:17)), 
  '151'=data.frame(ID=as.character(c(449,141,551,552)),11:14),
  '161'=data.frame(ID=as.character(171),11), '171'=data.frame(ID=as.character(161),11),
  '181'=data.frame(ID=as.character(881:882),11:12) )

lst2 <- list('121'=data.frame(ID=as.character(c(141,221,228,229,449)),11:15, 21:25), 
	 '131'=data.frame(ID=as.character(c(228,331,332,333,339)),11:15, 21:25), 
  '141'=data.frame(ID=as.character(c(121,151,229,339,441,442,449)), c(11:17), 21:27), 
  '151'=data.frame(ID=as.character(c(449,141,551,552)), 11:14, 21:24),
  '161'=data.frame(ID=as.character(171), 11,21), '171'=data.frame(ID=as.character(161), 11,21),
  '181'=data.frame(ID=as.character(881:882), 11:12,21:22) )

(te1 <- filterNetw(lst2, limInt=90, remOrphans=FALSE))
(te2 <- filterNetw(lst2, limInt=90, remOrphans=TRUE))

(te3 <- filterNetw(lst2, limInt=13, remOrphans=FALSE))
(te4 <- filterNetw(lst2, limInt=13, remOrphans=TRUE))


}
\seealso{
in \code{\link[base]{cbind}}
}
