% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testRobustToNAimputation.R
\name{testRobustToNAimputation}
\alias{testRobustToNAimputation}
\title{Test robust to NA-imputation}
\usage{
testRobustToNAimputation(dat, gr, annot = NULL, retnNA = TRUE,
  avSdH = c(0.18, 0.5), avSdL = c(0.1, 0.5), plotHist = FALSE,
  xLab = NULL, tit = NULL, seedNo = 2018, nLoop = 20,
  lfdrInclude = TRUE, ROTSn = NULL, silent = FALSE,
  callFrom = NULL)
}
\arguments{
\item{dat}{(matrix or data.frame) main data (may contain \code{NA})}

\item{gr}{(character or factor) replicate association}

\item{annot}{(matrix or data.frame) annotation (lines must match lines of data !)}

\item{retnNA}{(logical) retain and report number of \code{NA}}

\item{avSdH}{(numeric) population characteristics (mean and sd) for >1 \code{NA} neighbours 'high' (per line)}

\item{avSdL}{(numeric) population characteristics (mean and sd) for >0 \code{NA} neighbours 'low' (per line)}

\item{plotHist}{(logical) additional plot}

\item{xLab}{(character) custom x-axis label}

\item{tit}{(character) custom title}

\item{seedNo}{(integer) seed-value for normal random values}

\item{nLoop}{(integer) number of runs of independent \code{NA}-imputation}

\item{lfdrInclude}{(logical) include lfdr estimations (may cause warning message(s) concerning convergence if few too lines/proteins in dataset tested).}

\item{ROTSn}{(integer) number of repeats by \code{ROTS}, if \code{NULL} \code{ROTS} will not be called}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
matrix including imputed values or list of final and matrix with number of imputed by group. Various options of multiple testing ccorrection are implemented ('BY','lfdr','p.value' and 'ROTS.BH'
}
\description{
\code{testRobustToNAimputation} replaces \code{NA} values based on group neigbours (based on grouping of columns in argument \code{gr}), following overall assumption of close to Gaussian distribution.
Furthermore, it is assumed that \code{NA}-values originate from experimental settings where measurements at or below detection limit are recoreded as \code{NA}.
In  such cases (eg in proteomics) it is current practice to replace \code{NA}-values by very low (random) values in order to be able to perform t-tests.
However, random normal values used for replacing may in rare cases deviate from the average (the 'assumed' value) and in particular, if multiple \code{NA} replacements are above the average, 
may look like induced biological data and be misinterpreted as so.      
By repeating multiple times the process of replacing \code{NA}-values and subsequent testing the results can be sumarized afterwards by median over all repeated runs to remmove the stochastic effect of individual NA-imputation.
Thus, one may gain stability towards random-character of \code{NA} imputations by repeating imputation & test 'nLoop' times and summarize p-values by median (results stabilized at 50-100 rounds).
It is necessary to define all groups of replicates in \code{gr} to obtain all possible pair-wise testing (multiple columns in $BH, $lfdr etc). 
Testing by package \href{https://bioconductor.org/packages/release/bioc/html/ROTS.html}{ROTS} may optionaly be included.
This function returns limma-like S3 list-object further enriched by additional fields/elements.
}
\examples{
set.seed(2015); rand1 <- round(runif(600)+rnorm(600,1,2),3)
dat1 <- matrix(rand1,ncol=6) + matrix(rep((1:100)/20,6),ncol=6)
dat1[13:16,1:3] <- dat1[13:16,1:3]+2   # augment lines 13:16 
dat1[19:20,1:3] <- dat1[19:20,1:3]+3   # augment lines 19:20
dat1[15:18,4:6] <- dat1[15:18,4:6]+1.4   # augment lines 15:18 
dat1[dat1 <1] <- NA                    # mimick some NAs for low abundance
## normalize data
boxplot(dat1,main="data before normalization")
dat1 <- wrMisc::normalizeThis(as.matrix(dat1),meth="median")
## designate replicate relationships in samples ...  
grp1 <- gl(2,3,labels=LETTERS[1:2])                   
## moderated t-test with repeated inputations (may take >10 sec,  >60 sec if ROTSn >0 !) 
PLtestR1 <- testRobustToNAimputation(dat=dat1,gr=grp1,retnNA=TRUE,nLoop=100,ROTSn=0,lfdr=FALSE)
names(PLtestR1)
}
\seealso{
\code{\link[wrMisc]{moderTest2grp}}, \code{\link[wrMisc]{pVal2lfdr}}, \code{\link[limma]{eBayes}}, \code{\link[stats]{t.test}},\code{\link[ROTS]{ROTS}}
}
