% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSampleMetaData.R
\name{readSampleMetaData}
\alias{readSampleMetaData}
\title{Read Sample Meta-data from Quantification-Software And/Or Sdrf And Align To Experimental Data}
\usage{
readSampleMetaData(
  sdrf = NULL,
  suplAnnotFile = NULL,
  quantMeth = "MQ",
  path = ".",
  abund = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{sdrf}{(character, list or data.frame) optional extraction and adding of experimenal meta-data:
if character, this may be the ID at ProteomeExchange or a similarly formatted local file. \code{sdrf} will get priority over \code{suplAnnotFile}, if provided.}

\item{suplAnnotFile}{(logical or character) optional reading of supplemental files produced by MaxQuant; if \code{gr} is provided, it gets priority for grouping of replicates
if \code{TRUE} default to files 'summary.txt' (needed to match information of \code{sdrf}) and 'parameters.txt' which can be found in the same folder as the main quantitation results;
if \code{character} the respective file-names (relative ro absolute path), 1st is expected to correspond to 'summary.txt' (tabulated text, the samples as given to MaxQuant) and 2nd to 'parameters.txt' (tabulated text, all parameters given to MaxQuant)}

\item{quantMeth}{(character) quantification method used}

\item{path}{(character) optional path of file(s) to be read}

\item{abund}{(matrix or data.frame) experimental quantitation data; only column-names will be used for aligning order of annotated samples}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a list with \code{$lev} and \code{$level} (grouping of samples given as integer), and \code{$meth} (method by which grouping as determined).
 If valid \code{sdrf} was given, the resultant list contains in addition \code{$sdrfDat} (data.frame of annotation). If software annotation has been found it will be shown in \code{$annotBySoft}.
 If all entries are invalid or entries do not pass the tests, this functions returns an empty \code{list}.
}
\description{
Sample annotation meta-data form \href{https://www.maxquant.org/}{MaxQuant}, ProteomeDiscoverer or similar, can be read using this function and relevant information extracted.
Furthermore, annotation in \href{https://github.com/bigbio/proteomics-metadata-standard}{sdrf-format} can be added (the order of sdrf will be adjated automatically, if possible).
This functions returns a list with grouping of samples into replicates and additional information gathered.
Input files compressed as .gz can be read as well.
}
\details{
When initally reading/importing quantitation data, typically very little is known about the setup of different samples in the underlying experiment.
The overall aim is to read and mine the corresponding sample-annotation documeneted by the quantitation-software and/or from n sdrf repository and to attach it to the experimental data.
This way, in subsequent steps of analysis (eg PCA, statictical tests) the user does not have to bother stuying the experimental setup to figure out which
samples should be considered as relicate of whom.

Sample annotation meta-data can be obtained from two sources :
 a) form additional files produced (and exported) by the initial quantitation software (so far MaxQuant and ProteomeDiscoverer have een implemeneted) or
 b) from the universal sdrf-format (from Pride or user-supplied).
Both types can be imported and checked in the same run, if valid sdrf-information is found this will be given priority.
For more information about the sdrf format please see \href{https://github.com/bigbio/proteomics-metadata-standard}{sdrf on github}.
}
\examples{
sdrf001819Setup <- readSampleMetaData("PXD001819")
str(sdrf001819Setup)

}
\seealso{
this function is used internally by \code{\link{readMaxQuantFile}} or \code{\link{readProtDiscovFile}}; \code{\link{readSdrf}} for reading sdrf-files, \code{\link[wrMisc]{replicateStructure}} for mining annotation columns
}
