% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalIsoFragm.R
\name{evalIsoFragm}
\alias{evalIsoFragm}
\title{Evaluate selected lines of pepTab (iso-mass) for preferential cutting sites}
\usage{
evalIsoFragm(
  z,
  prefFragPat = NULL,
  seqCol = "seq",
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{z}{(matrix) main input, must contain cols specified as seqCol and "no","tailAA","precAA"}

\item{prefFragPat}{(matrix) specifies preferential fragmentation (which combination of AA to consider cols cTer,nTer,score), default made by \code{.prefFragPattern()}}

\item{seqCol}{(character) column names for the column containing the sequence to search for preferential cutting sites}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
line ID-numbers (pepTab[,"no"]) for those below median score (ie to remove from pepTab) or NULL if nothing to remove due to preferential fragmentation
}
\description{
Evaluate selected lines of pepTab (iso-mass) for preferential cutting sites. Such sites are taken by default from \code{.prefFragPattern()} simplified from a publication 
 by the Kelleher group (Haverland 2017, J Am Soc Mass Spectrom) or can be furnished by the user.
}
\examples{
peTab <- matrix(c("9","13","14","15", "LPVIAGHEAAG","PVIAGHEAAGI","EKKPFSI","KKPFSIE", 
  "P","L","E","E", "I","V","E","E"),nr=4,dimnames=list(NULL,c("no","seq","precAA","tailAA")))
evalIsoFragm(peTab)
}
\seealso{
\code{\link{makeFragments}}
}
