% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{median_cl_boot}
\alias{median_cl_boot}
\title{Compute confidence interval of median by bootstrapping.}
\usage{
median_cl_boot(x, conf = 0.95, type = "basic", nrepl = 10^3)
}
\arguments{
\item{x}{Data for computation.}

\item{conf}{confidence interval with default 95\%.}

\item{type}{type for function boot.ci.}

\item{nrepl}{number of bootstrap replications, defaults to 1000.}
}
\value{
A tibble with one row and three columns: Median, CIlow, CIhigh.
}
\description{
\code{median_cl_boot} computes lower and upper confidence limits for the
estimated median, based on bootstrapping.
}
\examples{
# basic usage of median_cl_boot
median_cl_boot(x = mtcars$wt)
}
