% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UnaryFunctions.R
\name{as.UnaryFn}
\alias{as.UnaryFn}
\title{Convert a list of UnaryFns into a UnaryFn.}
\usage{
as.UnaryFn(items, env = parent.frame())
}
\arguments{
\item{items}{list of UnaryFn derived instances.}

\item{env}{environment to work in.}
}
\value{
UnaryFnList
}
\description{
Unary functions are evaluated in left to right or first to last order.
}
\examples{

f <- as.UnaryFn(list(pkgfn("base::sin", "x"), pkgfn("base::cos", "x")))
cat(format(f))
1:3 \%.>\% f

}
\seealso{
\code{\link{pkgfn}}, \code{\link{wrapfn}}, \code{\link{srcfn}}
}
