% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{forest}
\alias{forest}
\title{forest}
\usage{
forest(listOfFiles = NULL, optLogFilePath = NULL, beginTime = 0,
  endTime = 0, windowShift = 5, windowSize = 20, effectiveLength = TRUE,
  nominalF1 = 500, gender = "m", estimate = FALSE, order = 0,
  incrOrder = 0, numFormants = 4, window = "BLACKMAN",
  preemphasis = -0.8, toFile = TRUE, explicitExt = NULL,
  outputDirectory = NULL, forceToLog = useWrasspLogger, verbose = TRUE)
}
\arguments{
\item{listOfFiles}{vector of file paths to be processed by function}

\item{optLogFilePath}{path to option log file}

\item{beginTime}{= <time>: set begin of analysis interval to <time> seconds (default = 0: begin of data)}

\item{endTime}{= <time>:  set end of analysis interval to <time> seconds (default = 0: end of data)}

\item{windowShift}{= <dur>: set analysis window shift to <dur> ms (default: 5.0)}

\item{windowSize}{= <dur>: set analysis window size to <dur> ms (default: 30.0)}

\item{effectiveLength}{make window size effective rather than exact}

\item{nominalF1}{= <freq>: set nominal F1 frequency to <freq> Hz (default: 500.0 Hz)}

\item{gender}{= <code>: set gender specific parameters where 
<code> = f[emale], m[ale] or u[nknown] (when <code>=f: eff. window length = 12.5 ms nominal F1 = 560.0 Hz)}

\item{estimate}{insert rough frequency estimates of missing formants (default: frequency set to zero)}

\item{order}{decrease default order by 2 (one resonance less)}

\item{incrOrder}{increase default order by 2 (one resonance more)}

\item{numFormants}{= <num>: set number of formants to <num> (default: 4;  maximum: 8 or half the LP order)}

\item{window}{= <type>: set analysis window function to <type> (default: BLACKMAN)}

\item{preemphasis}{= <val>: set pre-emphasis factor to <val> (-1 <= val <= 0) 
(default: dependent on sample rate and nominal F1)}

\item{toFile}{write results to file (default extension is .fms)}

\item{explicitExt}{set if you wish to override the default extension}

\item{outputDirectory}{directory in which output files are stored. Defaults to NULL, i.e. 
the directory of the input files}

\item{forceToLog}{is set by the global package variable useWrasspLogger. This is set
to FALSE by default and should be set to TRUE is logging is desired.}

\item{verbose}{display infos & show progress bar}
}
\value{
nrOfProcessedFiles or if only one file to process return AsspDataObj of that file
}
\description{
forest function adapted from libassp
}
\details{
Formant estimation of the signal(s) in <listOfFiles>.
Raw resonance frequency and bandwidth values are
obtained by root-solving of the Linear Prediction
polynomial from the autocorrelation method and the
Split-Levinson-Algorithm (SLA). Resonances are then
classified as formants using the so-called Pisarenko
frequencies (by-product of the SLA) and a formant
frequency range table derived from the nominal F1
frequency. The latter may have to be increased by
about 12\% for female voices (see NominalF1 and Gender options).
Formant estimates will be written to a file with the
base name of the input file and extension '.fms'.
Default output is in SSFF binary format (tracks 'fm'
and 'bw')
}
\examples{
# get path to audio file
path2wav <- list.files(system.file("extdata", package = "wrassp"), 
                       pattern = glob2rx("*.wav"), 
                       full.names = TRUE)[1]

# calculate formant values
res <- forest(path2wav, toFile=FALSE)

# plot formant values
matplot(seq(0,numRecs.AsspDataObj(res) - 1) / rate.AsspDataObj(res) + 
          attr(res, 'startTime'), 
        res$fm, 
        type='l', 
        xlab='time (s)', 
        ylab='Formant frequency (Hz)')

}
\author{
Raphael Winkelmann

Lasse Bombien
}
