% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wlm.R
\name{wlm}
\alias{wlm}
\title{Wavelet linear models}
\usage{
wlm(dat, times, resp, pred, norm, scale.min = 2, scale.max.input = NULL,
  sigma = 1.05, f0 = 1)
}
\arguments{
\item{dat}{A list of matrices representing the data (or in the case of one location, a list of
vectors). All the same dimensions (respectively, lengths)}

\item{times}{The times at which measurements were made, spacing 1}

\item{resp}{Index in dat for the response variable of the model}

\item{pred}{Vector of indices in dat for the predictor variables of the model; must differ from \code{resp}}

\item{norm}{The normalization of wavelet transforms to use. One of "none", "powall", "powind". See details.}

\item{scale.min}{The smallest scale of fluctuation that will be examined. At least 2.}

\item{scale.max.input}{The largest scale of fluctuation that will be examined. Note that if this is set too high relative to the length of the timeseries it will be truncated.}

\item{sigma}{The ratio of each time scale examined relative to the next timescale. Greater than 1.}

\item{f0}{The ratio of the period of fluctuation to the width of the envelope}
}
\value{
\code{wlm} returns an object of class \code{wlm}. Slots are:
\item{dat}{The input data list, but reordered and subsetted so the response is first and only used predictors are included}
\item{times}{The times associated with the data}
\item{norm}{The input}
\item{wtopt}{The inputted wavelet transform options scale.min, scale.max.input, sigma, f0 in a list}
\item{wts}{List of transforms, normalized as specified in \code{norm}. Same length as the output \code{dat}, each entry a locations x time x timescales array of transforms.}
\item{timescales}{The timescales associated with the wavelet transforms of the data}
\item{coefs}{A list (data frame, actually) of complex vectors, each of length the same 
as \code{timescales}. These are the model coefficients (which depend on timescale), and 
correspond to the \code{wts}.}
\item{modval}{The model values.}
\item{coher}{Appropriately normalized version of coherence of the model and response transforms. See details.}
}
\description{
Fits wavelet linear models. Also the generator function of the \code{wlm} class, which
inherits from the \code{list} class.
}
\details{
Normalization is as specified in the documentation for \code{coh}, HOWEVER, only
the "\code{powall}" option is currently implemented, other choices throw an error. Details 
are specified in appendices S7 and S9 of Sheppard et al, 2018. The output \code{modval}
is v in appendix S7, and \code{coefs} are the betas in equation 12 in that appendix.
}
\examples{
times<-1:30
dat<-list(v1=matrix(rnorm(300),10,30),v2=matrix(rnorm(300),10,30),v3=matrix(rnorm(300),10,30),
          v4=matrix(rnorm(300),10,30),v5=matrix(rnorm(300),10,30))
dat<-lapply(FUN=function(x){cleandat(x,times,1)$cdat},X=dat)
resp<-2
pred<-c(1,3,4)
norm<-"powall"
res<-wlm(dat,times,resp,pred,norm)

}
\references{
Sheppard, LW et al. (2019) Synchrony is more than its top-down and climatic parts: interacting 
Moran effects on phytoplankton in British seas. Plos Computational Biology 15, e1006744. doi: 10.1371/journal.pcbi.1006744
}
\seealso{
\code{\link{wlm_methods}}, \code{\link{wlmtest}}, \code{\link{syncexpl}}, \code{\link{predsync}}, 
\code{browseVignettes("wsyn")}
}
\author{
Thomas Anderson, \email{anderstl@gmail.com}, Jon Walter, \email{jaw3es@virginia.edu}; Lawrence 
Sheppard, \email{lwsheppard@ku.edu}; Daniel Reuman, \email{reuman@ku.edu}
}
