% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_tests.R
\name{independence_test}
\alias{independence_test}
\title{Independence Test}
\usage{
independence_test(
  f_data,
  components,
  lag,
  alpha = 0.05,
  suppress_raw_output = FALSE,
  suppress_print_output = FALSE
)
}
\arguments{
\item{f_data}{the functional data matrix with observed functions in the columns}

\item{components}{A positive Integer specifying the number of principal components to project the data on;
ranked in order of importance (importance is determined by the proportion of the variance that is explained
by the individual principal component.)}

\item{lag}{A positive Integer value, specifying the maximum lag to include - this can be seen as the bandwidth
or lag-window.}

\item{alpha}{Numeric value between 0 and 1 specifying the significance level to be used in the specified
hypothesis test. The default value is 0.05. Note, the significance value is only ever used to compute the
1-alpha quantile of the limiting distribution of the specified test's test statistic.}

\item{suppress_raw_output}{Boolean value, FALSE by default. If TRUE, the function will not return the list
containing the p-value, quantile, and statistic.}

\item{suppress_print_output}{Boolean value, FALSE by default. If TRUE, the function will not print any
output to the console.}
}
\value{
If suppress_raw_output = FALSE, a list containing the test statistic, the 1-alpha quantile of the
limiting distribution, and the p-value computed from the specified hypothesis test. Also prints output
containing a short description of the test, the p-value, and additional information about the test if
suppress_print_output = FALSE.
}
\description{
\code{independence_test} Computes the independence test with a user-specified number of principal components
and range of lags.
}
\details{
The "independence" portmanteau test is a test of independence and identical distribution based on a
dimensionality reduction by projecting the data onto the most important functional principal components.
It is based on the resulting lagged cross-variances. This test is not for general white noise series, and
may not hold under functional conditionally heteroscedastic assumptions. Please consult the vignette for a
deeper exposition, and consult the reference for a complete treatment.
}
\examples{
b <- brown_motion(250, 100)
independence_test(b, components = 3, lag = 5)

}
\references{
[1] Gabrys R., & Kokoszka P. (2007). Portmanteau Test of Independence for Functional Observations.
Journal of the American Statistical Association, 102:480, 1338-1348, DOI: 10.1198/016214507000001111.
}
