% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{EBIquery_allTerm}
\alias{EBIquery_allTerm}
\title{EBIquery_allTerm}
\usage{
EBIquery_allTerm(term = "genes", termSize = 2000)
}
\arguments{
\item{term}{"associations", "molecular_phenotypes", "studies", "tissues", "qtl_groups", "genes" or "chromosomes".}

\item{termSize}{Number of fetched term.}
}
\value{
A data.table object.
}
\description{
EBIquery_allTerm
}
\examples{
\donttest{
# Fetch associatons:
associations <- data.table::rbindlist(EBIquery_allTerm("associations",termSize=0))

# fetch molecular_phenotypes:
molecular_phenotypes <- EBIquery_allTerm("molecular_phenotypes", termSize=10)

# fetch studies:
studies <- EBIquery_allTerm("studies")

# fetch tissues:
tissues <- EBIquery_allTerm("tissues")

# fetch tissue-study mapping relationships
tissue_S <- EBIquery_allTerm( paste0("tissues/", "UBER_0002046","/studies" ))

# fetch qtl groups:
qtl_groups <- EBIquery_allTerm("qtl_groups")

# Fetch genes:
geneList <- EBIquery_allTerm("genes", termSize=10)
}
}
