% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{xQTLquery_sampleBySampleId}
\alias{xQTLquery_sampleBySampleId}
\title{Query details of samples with GTEx IDs}
\usage{
xQTLquery_sampleBySampleId(
  sampleIds,
  recordPerChunk = 150,
  pathologyNotesCategories = FALSE
)
}
\arguments{
\item{sampleIds}{A character vector or a string of sample ID.}

\item{recordPerChunk}{(integer) number of records fetched per request (default: 200).}

\item{pathologyNotesCategories}{Default: pathologyNotes info is ignored.}
}
\value{
a data.table object of samples' information.
}
\description{
Query details of samples with GTEx IDs
}
\examples{
sampleIds <- c("GTEX-11NUK-0011-R4a-SM-DO12B", "GTEX-11ONC-0011-R4b-SM-DO93H",
               "GTEX-11DXY-0526-SM-5EGGQ", "GTEX-13OVJ-1026-SM-5IFGI")
sampleInfo <- xQTLquery_sampleBySampleId(sampleIds)
}
