% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_xSub.R
\name{info_xSub}
\alias{info_xSub}
\title{Information on available xSub files}
\usage{
info_xSub(details = FALSE, data_source = NULL, country_iso3 = NULL,
  country_name = NULL)
}
\arguments{
\item{details}{Logical. If \code{details=TRUE}, function returns information on available units of analysis for each country.}

\item{data_source}{Subset results by data sources. Character string or vector.}

\item{country_iso3}{Subset results by country codes (ISO3). Character string or vector.}

\item{country_name}{Subset results by country name. Character string or vector.}
}
\description{
This function reports the availability of files on the \code{www.x-sub.org} server, and corresponding country codes and units of analysis. For additional info, see \code{www.x-sub.org/about/what-is-xsub}.
}
\examples{
# General info on data sources and countries
info_xSub()

# Available files for Pakistan
info_xSub(country_name = "Pakistan")

# Detailed info for Pakistan
info_xSub(details=TRUE,country_name = "Pakistan")

# Available files for SCAD data source
info_xSub(data_source = "SCAD")
}
\seealso{
\code{\link{get_xSub}}, \code{\link{get_xSub_multi}}
}
