% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sample_hp_v9_Commented.R
\name{sample_hp}
\alias{sample_hp}
\title{Sample from historical population}
\usage{
sample_hp(hp_out, Male_founders, Female_founders, ng, litter_size, Selection,
  Training, saveAt, sh_output, Display)
}
\arguments{
\item{hp_out}{(\code{list}) Output of function  \code{\link{make_hp}}.}

\item{Male_founders}{(\code{data.frame}) Data frame with {1} row and {3} columns as following:\cr
  Column  1) "number" is the number of male individuals to be selected from the last generation of historical population. \cr
  Column 2) "select" indicates the type of selection with options:
\itemize{
\item{"rnd"}  {Select individuals randomly}.
\item{"phen"}  {Select individuals based on their phenotypes}.
\item{"tbv"}  {Select individuals based on their true breeding value (tbv)}.
}
  Column  3) "value" Indicates to select hight: "h" or low: "l" values. Note: This Column is ignored if individuals are selected randomly.\cr}

\item{Female_founders}{(\code{data.frame}) Data frame with {1} row and {3} columns as following:\cr
  Column 1) "number" is the number of female individuals to be selected from the last generation of historical population. \cr
  Column 2) "select" indicates the type of selection with options:
\itemize{
\item{"rnd"}  {Select individuals randomly}.
\item{"phen"}  {Select individuals based on their phenotypes}.
\item{"tbv"}  {Select individuals based on their true breeding value (tbv)}.
}
  Column 3) "value" Indicates to select "h" or "l" values. Note: This column is ignored if individuals are selected randomly.\cr}

\item{ng}{Number of generations. Range: \eqn{1 \leq \code{ng} \leq 500}.}

\item{litter_size}{Litter size or the number of progeny per dam. Range: \eqn{1 \leq \code{x} \leq 200}.}

\item{Selection}{(\code{data.frame}) Data frame with {2} rows and {3} colomns. First row is for the selection design of males and second row is for the selection design of females. The colomns are as following:\cr
  Column 1) "size" is the number of individuals to be selected as sires/dams. \cr
  Column 2) "type" indicates the type of selection with options:
\itemize{
\item{"rnd"}  {Select individuals randomly}.
\item{"phen"}  {Select individuals based on their phenotypes}.
\item{"tbv"}  {Select individuals based on their true breeding value (tbv)}.
\item{"gebv"}  {Select individuals based on their genomic estimated breeding value (gebv)}.
}
  Column 3) "value" Indicates to select "h" or "l" values. Note: This column is ignored if individuals are selected randomly.\cr}

\item{Training}{\emph{Optional} (\code{data.frame}) Data frame with {1} row and {8} columns. The columns are as following:\cr
 Column 1) "size" is the number of individuals to be selected for training. \cr
 Column 2) "sel" \emph{Optional} (\code{character}) Indicates the type of the selection of individuals for training. The possible options are:
\itemize{
\item{"rnd"}  {Select individuals for training randomly}.
\item{"min_rel_mrk"}  {Select individuals for training, where genomic relationship among individuals based on marker information is minimum}.
\item{"max_rel_mrk"}  {Select individuals for training, where genomic relationship among individuals based on marker information is maximum}.
\item{"min_rel_qtl"}  {Select individuals for training, where genomic relationship among individuals based on qtl information is minimum}.
\item{"max_rel_qtl"}  {Select individuals for training, where genomic relationship among individuals based on qtl information is maximum}.
}
Default: "rnd" \cr
  Column 3) "method" \emph{Optional} (\code{character}) Method used for the estimation of marker effects. The possible options are:
\itemize{
\item{"BRR"}  {Gaussian prior}.
\item{"BayesA"}  {scaled-t prior}.
\item{"BL"}  {Double-Exponential prior}.
\item{"BayesB"}  {two component mixture prior with a point of mass at zero and a sclaed-t slab}.
\item{"BayesC"}  {two component mixture prior with a point of mass at zero and a Gaussian slab}.
}
Default: "BRR" \cr
 Column 4) "nIter" \emph{Optional} The number of iterations. Default:{1500} \cr
  Column 5) "burnIn" \emph{Optional} The number of burn-in. Default:{500} \cr
  Column 6) "thin" \emph{Optional} The number of thinning. Default:{5} \cr
  Column 7) "save" \emph{Optional} This may include a path and a pre-fix that will be added to the name of the files that are saved as the program runs.  Default:"Out_BGLR" \cr 
  Column 8) "show" \emph{Optional} (\code{Logical}) if TRUE the iteration history is printed. Default: \code{TRUE}. \cr
\bold{Note:} This argument is compulsory if \code{"type"} in argument \code{Selection} is "gebv".  More details about the argument can be found in package \pkg{BGLR}.}

\item{saveAt}{\emph{Optional} (\code{character}). Name to be used to save output files.}

\item{sh_output}{\emph{Optional} (\code{data.frame}). Data frame to specify generations indexs and type of data to be written to output files. User can define which type of data and which generation to be written to output files. The possible options are:\cr
\cr
  "data" Individuals data except their genotypes. \cr
  "qtl" QTL genotye of individuals coded as {11,12,21,22}. \cr
  "marker" Marker genotye of individuals. \cr
  "seq" Genotype (both marker (SNP) and QTL) of individuals.\cr
  "freq_qtl" QTL allele frequency. \cr
  "freq_mrk" Marker allele frequency. \cr
Note: Both arguments \code{sh_output} and \code{saveAt} should present in the function in order to write the output files.}

\item{Display}{\emph{Optional} (\code{Logical}) Display summary of the simulated generations if is not \code{FALSE}. Default: \code{TRUE}.}
}
\value{
\code{list} with all data of simulated generations.\cr
\describe{
\item{$output}{(\code{list}) Two-level list  (\code{$output[[]][[]]}) containing information about simulated generations. First index (x) indicates generation number. It should be noted that as data for base generation (0) is also stored by the function, to retrive data for a specific generation, index should be equal to generation number plus one. As an example to observe data for generation 2 index should be 3 i.e, \code{$output[[3]]$data}. Second index (y) that ranges from {1} to {6} contain the information as following: 
\itemize{
\item{\code{$output[[x]]$data}}  {Individuals data except their genotypes. Here x is the generation index}.
\item{\code{$output[[x]]$qtl}}  {QTL genotye of individuals.}.
\item{\code{$output[[x]]$mrk}}   {Marker genotye of individuals}.
\item{\code{$output[[x]]$sequ}}  {Genotype (both marker (SNP) and QTL) of individuals}.
\item{\code{$output[[x]]$freqQTL}}   {QTL allele frequency}.
\item{\code{$output[[x]]$freqMRK}}   {Marker allele frequency}.
}
}
\item{$summary_data}{Data frame with summary of simulated generations}. 
\item{$linkage_map_qtl}{Linkage map for qtl}.  
\item{$linkage_map_mrk}{Linkage map for marker}.
\item{$linkage_map_qtl_mrk}{Integrated linkage map for both marker and qtl}.
\item{$allele_effcts}{QTL allele effects}.
\item{$trait}{Trait specifications}.
\item{$genome}{Genome specifications}.
}
}
\description{
Samples individuals from historical population as founders and simulates subsequent generations for a recent population based on user defined selection parameters.
}
\details{
Function \code{sample_hp} is used to create recent population(s). This function can be used multiple times to sample individuals from the historical population created by function \code{\link{make_hp}}. For the start up of the recent population, male and female founders come from the last generation of historical population and can be selected based on one of the options described in argument \code{Male_founders} or \code{Female_founders}. For the subsequent generations individuals can be selected based on genomic estimated breeding value "gebv". To do so, argument \code{Training} should present in the model to estimate the marker effects. Selected individuals for training are always from a generation preceding the target generation. As an example, for the calculation of GEBV for the individuals in generation {4}, selected individuals from generation {3} are used for training. In order to select individuals for training, user can control type of selection by argument \code{Training}. For the options "min_rel_mrk" and "max_rel_mrk", genomic relationship matrix is constructed as following:\cr
\deqn{G = ZZ'/ 2\sum_{j=1}^{m} p_j(1-p_j)}  \cr 
where \eqn{Z=M-P}. Here \eqn{M} is an allele-sharing matrix with \eqn{m} columns (\eqn{m} = number of markers) and \eqn{n} rows (\eqn{n} = number of genotyped individuals), and \eqn{P} is a matrix containing the frequency of the second allele (\eqn{p_j}), expressed as \eqn{2p_j}. \eqn{M_{ij}} is 0 if the genotype of individual \eqn{i} for SNP \eqn{j} is homozygous {11}, is {1} if heterozygous, or {2} if the genotype is homozygous {22}. Frequencies are the observed allele frequency of each SNP. After constructing genomic relationship matrix, individuals are sorted based on their genomic relationship. User can define whether to select individuals with low relationship ("min_rel_mrk") or high relationship ("max_rel_mrk") among each other for training. As an example if option "min_rel_mrk" is considered, then selected individuals for training have the lowest relationship with each other compared to the whole population they belong. \cr  
\cr
Genomic relationship matrix for the options "min_rel_qtl" and "max_rel_qtl" are constracted as the same procedure described above except that qtl genotype of individual rather than markers are used to calculate genomic relationships among individuals. \cr  
\cr 
The main features for \code{sample_hp} are as following:
\itemize{
 \item{}{Selection criteria can differ between males and females.}
 \item{}{Different models can be used for the estimation of marker effects.}
 \item{}{Multiple options for constructing the reference population for training.}
 \item{}{Dynamic control of output files to be saved.}
}
}
\examples{
# # # Simulation of a recent population following a historical population. 

# CREATE HISTORICAL POPULATION

genome<-data.frame(matrix(NA, nrow=2, ncol=6))
names(genome)<-c("chr","len","nmrk","mpos","nqtl","qpos")
genome$chr<-c(1,2)
genome$len<-c(50,60)	
genome$nmrk<-c(130,75)
genome$mpos<-c("rnd","rnd")	
genome$nqtl<-c(30,30)
genome$qpos<-rep("even",2)	
genome

hp<-make_hp(hpsize=100
,ng=10,h2=0.3,d2=0.15,phen_var=1
,genome=genome,mutr=5*10**-4,sel_seq_qtl=0.05,sel_seq_mrk=0.05,laf=0.5)

# # MAKE FIRST RECENT POPULATION USING FUNCTION sample_hp 

Male_founders<-data.frame(number=50,select="rnd") 
Female_founders<-data.frame(number=50,select="rnd")   

# Selection scheme in each generation of recent population 

Selection<-data.frame(matrix(NA, nrow=2, ncol=2))
names(Selection)<-c("Number","type")
Selection$Number[1:2]<-c(50,50)	
Selection$type[1:2]<-c("rnd","rnd")	
Selection

# Save "data" and "freq_mrk" for first and last generation of RP

my_files<-data.frame(matrix(NA, nrow=2, ncol=2))
names(my_files)<-c("data","marker")
my_files[,1]<-c(1,4) # Save data for generations 1 and 4
my_files[,2]<-c(1,4) # Save freq_mrk for generations 1 and 4
my_files

RP<-sample_hp(hp_out=hp,Male_founders=
Male_founders,Female_founders=Female_founders,
ng=4,Selection=Selection,litter_size=3,saveAt="my_RP",sh_output=my_files,Display=TRUE)

# Some results 

RP$summary_data
RP$output[[2]]$data      # Data for 1st Generation
RP$output[[4]]$freqMRK   # Marker frequencies for 3rd Generation
RP$linkage_map_qtl
RP$allele_effcts
}
\seealso{
\code{\link{make_hp}}
}
