% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conticnt.R
\name{conticnt}
\alias{conticnt}
\title{continuous counting}
\usage{
conticnt(x, col, opr = "==", threshold = 0, cnt = FALSE)
}
\arguments{
\item{x}{a numeric vector or a data frame.}

\item{col}{a numeric column name.}

\item{opr}{relational operators, defaults to ==.}

\item{threshold}{threshold value, defaults to 0.}

\item{cnt}{whether to count the number rows in each continuous groups.}
}
\value{
A integer vector indicating the number of elements in argument x continuous comparing with a threshold.
}
\description{
It counts the number of values continuous comparing with a threshold.
}
\examples{
# example I
x1 = c(0,0,0, 1,1,1, 0,0, 1,1)
conticnt(x1)
conticnt(x1, cnt = TRUE)
conticnt(x1, opr = '<=')

# example II
x2 = data.frame(x = c(0,0,0, 1,1,1, 0,0, 1,1))
conticnt(x2, col='x')
conticnt(x2, col='x', cnt=TRUE)
conticnt(x2, col='x', opr='<=')

library(data.table)
setDT(x2)[, ct_N := conticnt(x)][]

# example III
# number of growth values
x3 = data.frame(x = c(0,1,2, 3,2,1, 0,1, 2,1))
x3 = setDT(x3)[, diff := x - shift(x,type='lag',fill = 0)]
conticnt(x3, col='diff', opr = '>=')

}
