% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNF.R
\name{makeSymbolTable}
\alias{makeSymbolTable}
\title{Build a symbol table from a character string which contains a BNF.}
\usage{
makeSymbolTable(BNF)
}
\arguments{
\item{BNF}{A character string with the BNF.}
}
\value{
A data frame with the columns 
   \code{Symbols}, \code{NonTerminal}, and \code{SymbolID}.
}
\description{
\code{makeSymbolTable()} extracts all terminal 
             and non-terminal symbols from a BNF
             and builds a data frame with the columns 
             Symbols (string), NonTerminal (0 or 1), and SymbolId (int).
             The symbol "NotExpanded" is added which codes
             depth violations of a derivation tree.
}
\examples{
makeSymbolTable(booleanGrammar()$BNF)

}
