% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgrove.R
\name{upsilon}
\alias{upsilon}
\title{Explainability}
\usage{
upsilon(porig, pexp)
}
\arguments{
\item{porig}{An object of class \code{xgrove}.}

\item{pexp}{Name of the measure to be plotted on the x-axis, either \code{"trees"}, \code{"rules"}, \code{"upsilon"} or \code{"cor"}.}
}
\value{
Numeric explainability upsilon.
}
\description{
Compute explainability given predicted data of the model and an explainer.
}
\examples{
library(randomForest)
library(pdp)
data(boston)
set.seed(42)
# Compute original model
rf <- randomForest(cmedv ~ ., data = boston)
data <- boston[,-3] # remove target variable
# Compute predictions
porig <- predict(rf, data)

# Compute surrogate grove
xg <- xgrove(rf, data)
pexp <- predict(xg$model, data, n.trees = 16)
upsilon(porig, pexp)

}
\references{
\itemize{
    \item {Szepannek, G. and Luebke, K.(2023): How much do we see? On the explainability of partial dependence plots for credit risk scoring,
           Argumenta Oeconomica 50, DOI: 10.15611/aoe.2023.1.07}.
  }
}
\author{
\email{gero.szepannek@web.de}
}
