% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_tskrr.fit.R
\name{impute_tskrr.fit}
\alias{impute_tskrr.fit}
\title{Impute values based on a two-step kernel ridge regression}
\usage{
impute_tskrr.fit(y, Hk, Hg, naid = NULL, niter, tol, start, verbose)
}
\arguments{
\item{y}{a label matrix}

\item{Hk}{a hat matrix for the rows (see also \code{\link{eigen2hat}}
on how to calculate them from an eigen decomposition)}

\item{Hg}{a hat matrix for the columns. For homogeneous networks, this
should be Hk again.}

\item{naid}{an optional index with the values that have to be imputed,
i.e. at which positions you find a \code{NA} value. It can be a vector
with integers or a matrix with \code{TRUE}/\code{FALSE} values.}

\item{niter}{an integer giving the maximum number of iterations}

\item{tol}{a numeric value indicating the tolerance for convergence of
the algorithm. It is the maximum sum of squared differences between
to iteration steps.}

\item{start}{a numeric value indicating the value with which NA's are
replaced in the first step of the algorithm. Defaults to 0.}

\item{verbose}{either a logical value, 1 or 2. \code{1} means "show the number
of iterations and the final deviation", \code{2} means "show the deviation
every 10 iterations". A value \code{TRUE} is read as \code{1}.}
}
\value{
a list with two elements:
\itemize{
\item a matrix \code{y} with the imputed values filled in.
\item a numeric value \code{niter} with the amount of iterations
}
}
\description{
This function provides an interface for the imputation of values
based on a \code{\link{tskrr}} model and is the internal function
used by \code{\link{impute_tskrr}}.
}
\details{
This function is mostly available for internal use. In most cases,
it makes much more sense to use \code{\link{impute_tskrr}}, as that
function returns an object one can work with. The function
\code{impute_tskrr.fit} could be useful when doing simulations or
creating fitting algorithms.
}
\examples{

data(drugtarget)

K <- eigen(targetSim)
G <- eigen(drugSim)

Hk <- eigen2hat(K$vectors, K$values, lambda = 0.01)
Hg <- eigen2hat(G$vectors, G$values, lambda = 0.05)

drugTargetInteraction[c(3,17,123)] <- NA

res <- impute_tskrr.fit(drugTargetInteraction, Hk, Hg,
                        niter = 1000, tol = 10e-10,
                        start = 0, verbose = FALSE)

}
\seealso{
\itemize{
\item \code{\link{impute_tskrr}} for the user-level function, and
\item \code{\link{eigen2hat}} for conversion of a eigen decomposition to
a hat matrix.
}
}
