% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/residuals.R
\name{residuals}
\alias{residuals}
\alias{residuals.tskrr}
\alias{residuals,tskrr-method}
\title{calculate residuals from a tskrr model}
\usage{
residuals(object, ...)

\method{residuals}{tskrr}(
  object,
  method = c("predictions", "loo"),
  exclusion = c("interaction", "row", "column", "both"),
  replaceby0 = FALSE,
  ...
)

\S4method{residuals}{tskrr}(
  object,
  method = c("predictions", "loo"),
  exclusion = c("interaction", "row", "column", "both"),
  replaceby0 = FALSE,
  ...
)
}
\arguments{
\item{object}{a tskrr model}

\item{...}{arguments passed from/to other methods.}

\item{method}{a character value indicating whether the
residuals should be based on the predictions or on a
leave-one-out crossvalidation.}

\item{exclusion}{a character value with possible values "interaction",
"row", "column", "both" for heterogeneous models, and "edges", "vertices",
"interaction" or "both" for homogeneous models.
Defaults to "interaction". See details.}

\item{replaceby0}{a logical value indicating whether the interaction
should be simply removed (\code{FALSE}) or replaced by 0 (\code{TRUE}).}
}
\value{
a matrix(!) with the requested residuals
}
\description{
This function returns the residuals for
an object inheriting from class \code{\link[xnet:tskrr-class]{tskrr}}
}
\details{
The parameter \code{exclusion} defines what is left out.
The value "interaction" means that a single interaction is removed.
In the case of a homogeneous model, this can be interpreted as the
removal of the interaction between two edges. The values "row" and
"column" mean that all interactions for a row edge resp. a column
edge are removed. The value "both" removes all interactions for
a row and a column edge.

In the case of a homogeneous model, "row" and "column" don't make sense
and will be replaced by "both" with a warning. This can be interpreted
as removing vertices, i.e. all interactions between one edge and
all other edges. Alternatively one can use "edges" to remove edges and
"vertices" to remove vertices. In the case of a homogeneous model,
the setting "edges" translates to "interaction", and "vertices"
translates to "both". For more information, see Stock et al. (2018).

Replacing by 0 only makes sense when \code{exclusion = "interaction"} and the
label matrix contains only 0 and 1 values. The function checks whether
the conditions are fulfilled and if not, returns an error.
}
\examples{

data(drugtarget)
mod <- tskrr(drugTargetInteraction, targetSim, drugSim,
             lambda = c(0.01,0.01))
delta <- response(mod) - loo(mod, exclusion = "both")
resid <- residuals(mod, method = "loo", exclusion = "both")
all.equal(delta, resid)

}
