% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_tskrrTune.R
\docType{class}
\name{tskrrTune-class}
\alias{tskrrTune-class}
\alias{tskrrTune}
\title{Class tskrrTune}
\description{
The class tskrrTune represents a tuned \code{\link[xnet:tskrr-class]{tskrr}}
model, and is the output of the function \code{\link{tune}}. Apart from
the model, it contains extra information on the tuning procedure. This is
a virtual class only.
}
\section{Slots}{

\describe{
\item{\code{lambda_grid}}{a list object with the elements \code{k} and possibly
\code{g} indicating the tested lambda values for the row kernel \code{K}
and - if applicable - the column kernel \code{G}. Both elements have
to be numeric.}

\item{\code{best_loss}}{a numeric value with the loss associated with the
best lambdas}

\item{\code{loss_values}}{a matrix with the loss results from the searched grid.
The rows form the X dimension (related to the first lambda), the columns
form the Y dimension (related to the second lambda if applicable)}

\item{\code{loss_function}}{the used loss function}

\item{\code{exclusion}}{a character value describing the exclusion used}

\item{\code{replaceby0}}{a logical value indicating whether or not the cross
validation replaced the excluded values by zero}

\item{\code{onedim}}{a logical value indicating whether the grid search
was done in one dimension. For homogeneous networks, this is
true by default.}
}}

\seealso{
\itemize{
\item the function \code{tune} for the tuning itself
\item the class \code{\link{tskrrTuneHomogeneous}} and
\code{tskrrTuneHeterogeneous} for the actual classes.
}
}
