% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_effects.R
\name{capture_side_effects}
\alias{capture_side_effects}
\title{Capture side effects}
\usage{
capture_side_effects(expr, envir = NULL, reset_seed = FALSE)
}
\arguments{
\item{expr}{Expression.}

\item{envir}{Environment to evaluate expression in.}

\item{reset_seed}{Whether to reset the random state on exit. (Logical)}
}
\value{
Named list with the side effects.
}
\description{
Captures errors, warnings, and messages from an expression.

In case of an error, no other side effects are captured.

Simple wrapper for \code{testthat}'s
\code{\link[testthat:capture_error]{capture_error()}},
\code{\link[testthat:capture_warnings]{capture_warnings()}} and
\code{\link[testthat:capture_messages]{capture_messages()}}.

Note: Evaluates \code{expr} up to three times.
}
\examples{
# Attach packages
library(xpectr)

fn <- function(raise = FALSE){
  message("Hi! I'm Kevin, your favorite message!")
  warning("G'Day Mam! I'm a warning to the world!")
  message("Kevin is ma name! Yesss!")
  warning("Hopefully the whole world will see me :o")
  if (isTRUE(raise)){
    stop("Lord Evil Error has arrived! Yeehaaa")
  }
  "the output"
}
\donttest{
capture_side_effects(fn())
capture_side_effects(fn(raise = TRUE))
}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
