% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xset_plots.R
\name{franken_prop}
\alias{franken_prop}
\title{Combine a property from all components of a \code{franken_xpdb}}
\usage{
franken_prop(
  xpdb_f,
  xpdb_list,
  prop,
  problem = NULL,
  glue_cmd = function(x) glue::glue_collapse(x, ", ", last = " and "),
  indices = seq_along(xpdb_list)
)
}
\arguments{
\item{xpdb_f}{A product of \code{\link{franken_xpdb}}}

\item{xpdb_list}{List of the source \code{xpose_data} objects.}

\item{prop}{<\code{character}> of the property to combine}

\item{problem}{<\code{numeric}> If necessary to specify}

\item{glue_cmd}{Any special transformation to the properties,
including how to collapse.}

\item{indices}{<\code{numeric}> Index values \code{1:length(xpdb_list)}
to include in the property collapse.}
}
\value{
Same as \code{xpdb_f} with new properties.
}
\description{
Combine a property from all components of a \code{franken_xpdb}
}
\details{
This function is meant to be called within \code{\link{franken_xpdb}}.
It is expected to be ready to handle cases where, for example,
multiple props are being set in a pipe, or a problem-associated
property is being set while a problem=0 property is also being
set.

This is a \emph{low-level} function, so its use outside of internal
functions is not intended.
}
\examples{
\donttest{
# This is designed to be called in a function environment which
# would provide something like the following:

xpdb_f <- franken_xpdb(pheno_base, pheno_final, .types="catcov")

xpdb_list <- list(pheno_base, pheno_final)

# The following would be inside the function
xpdb_f \%>\%
  franken_prop(xpdb_list, "run",
    glue_cmd = function(x) paste(x, collapse="+"))

# xpdb_f may have to be written to a few times if
# and problem-specific combinations are needed:

updated <- xpdb_f \%>\%
  franken_prop(xpdb_list, "run",
    glue_cmd = function(x) paste(x, collapse="+"))

# problem will also be available. Assume there's
# no reason to loop here, but that may be needed
problem <- 1
updated <- updated \%>\%
  franken_prop(xpdb_list, "ofv",  problem=problem,
    glue_cmd = function(x) paste(x, collapse="&"))
}
}
\keyword{internal}
