% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xplot_helpers.R
\name{parse_title}
\alias{parse_title}
\title{Parse keywords in string based on values contained in an xpdb}
\usage{
parse_title(
  string,
  xpdb,
  problem,
  quiet,
  extra_key = NULL,
  extra_value = NULL,
  ignore_key = NULL
)
}
\arguments{
\item{string}{A string containing keywords (e.g. `@nobs`) to be parsed 
(e.g. title, label, etc.) using values stored in the `xpdb$summary`.}

\item{xpdb}{An xpose database object.}

\item{problem}{The $problem number to be used.}

\item{quiet}{Should messages be displayed to the console.}

\item{extra_key}{A vector of additional keywords not available in the `xpdb$summary`.}

\item{extra_value}{A vector of values matching the order of `extra_key`.}

\item{ignore_key}{A vector of keywords to be ignored i.e. warnings will not be returned.}
}
\value{
The parsed `string`.
}
\description{
Parse keywords in string based on values contained in an xpdb
}
\keyword{internal}
