% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/util.R
\name{FilterNetwork}
\alias{FilterNetwork}
\title{Filter network}
\usage{
FilterNetwork(net, weight, min.weight = 0.8, min.conn.strength = 0.4,
  min.num.conn = 5, max.num.conn = 50, remove.self.connection = TRUE,
  debug = FALSE)
}
\arguments{
\item{net}{List, a gene interaction network}

\item{weight}{The weights of genes, could from the function \code{EstimateExpression}}

\item{min.weight}{Filter the connected genes with weights less than \code{min.weight}}

\item{min.conn.strength}{The minimum gene connection strength}

\item{min.num.conn}{The minimum number of connections required for a gene to be considered for trans-analysis}

\item{max.num.conn}{Only keep the top max.conn genes}

\item{remove.self.connection}{Logical, whether removing self-connections or not}

\item{debug}{Logical, specifying whether debug information should be printed}
}
\value{
The filtered network
}
\description{
Filter network
}
\examples{
data(net)
net.filt = FilterNetwork(net)
}

