% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cryptic_transcripts_methods.R
\name{zscore_score}
\alias{zscore_score}
\title{Z score}
\usage{
zscore_score(geneCoverage, iterations = 10000)
}
\arguments{
\item{geneCoverage}{object of type geneCoverage containing the
RNA-seq coverage values for one gene.}

\item{iterations}{A number indicating the number of iterations. Default = 10000.}
}
\value{
An object of class 'CrypticScore' with the following components:
      \item{geneAnnotation}{An object of class \code{\link{annotationsSet}}
                             containing the information on the gene.}
       \item{crypticScore}{Cryptic score obtained by comparing
                           type2 data to type1 data}
       \item{controls}{A list containing the scores obtained by
                       comparing replicates of each type of data}
       \item{method}{The method used.}
}
\description{
Calculates the cryptic score (z score) using the probabilistic method.
}
\examples{

data(yer109c)
zscore_score(geneCoverage = yer109c, iterations = 1000)
}

