% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify.R
\name{modify.default}
\alias{modify.default}
\title{Modify Attributes of Indicated Components by Default}
\usage{
\method{modify}{default}(
  x,
  ...,
  .reserved = getOption("yamlet_modify_reserved", c("class", "levels", "labels",
    "names"))
)
}
\arguments{
\item{x}{object}

\item{...}{indicated columns, or name-value pairs}

\item{.reserved}{reserved labels that warn on assignment}
}
\value{
same class as x
}
\description{
Modifies the attributes of each indicated element
(all elements by default).  Tries to assign the value of an expression
to the supplied label, with existing attributes
and the object itself (.) available as arguments.
Gives a warning if the supplied label is considered reserved.
Intends to support anything with one or more non-empty names.
}
\details{
The name of the component itself is available during assignments as
attribute 'name' (any pre-existing attribute 'name' is temporarily masked).
After all assignments are complete, the value of 'name' is enforced at the object level.
Thus, \code{modify} expressions can modify component names.

As currently implemented, the expression is evaluated by
\code{\link[rlang]{eval_tidy}}, with attributes supplied as
the \code{data} argument.  Thus, names in the expression
may be disambiguated, e.g. with \code{.data}.  See examples.
}
\examples{
library(magrittr)
library(dplyr)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(file)

# modify selected columns
x \%<>\% modify(title = paste(label, '(', guide, ')'), time)
x \%>\% select(time, conc) \%>\% decorations

# modify (almost) all columns
x \%<>\% modify(title = paste(label, '(', guide, ')'), -Subject)
x \%>\% select(time, conc) \%>\% decorations

# use column itself
x \%<>\% modify(`defined values` = sum(!is.na(.)))
x \%>\% select(time) \%>\% decorations

# rename column
x \%<>\% modify(time, name = label)
names(x)

# warn if assignment fails
\dontrun{
\donttest{
x \%<>\% modify(title = foo, time)
}}
# support lists
list(a = 1, b = 1:10, c = letters) \%>\%
modify(length = length(.), b:c)

x \%<>\% select(Subject) \%>\% modify(label = NULL, `defined values` = NULL)

# distinguish data and environment
location <- 'environment'
x \%>\% modify(where = location) \%>\% decorations
x \%>\% modify(where = .env$location) \%>\% decorations
\dontrun{
\donttest{
x\%>\% modify(where = .data$location) \%>\% decorations
}}
x \%>\% modify(location = 'attributes', where = location) \%>\% decorations
x \%>\% modify(location = 'attributes', where = .data$location) \%>\% decorations

}
\seealso{
Other modify: 
\code{\link{modify}()},
\code{\link{named}()},
\code{\link{selected.default}()},
\code{\link{selected}()}

Other interface: 
\code{\link{as.data.frame.yamlet}()},
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
\concept{modify}
