% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syncPlotters.R
\name{plotSyncModelResids}
\alias{plotSyncModelResids}
\title{Plot residuals of sync_model to enable check of model}
\usage{
plotSyncModelResids(sync_model, by = "overall")
}
\arguments{
\item{sync_model}{Synchronization model obtained using \code{getSyncModel()}}

\item{by}{What to facet/group the plot by? Currently supports one of 'overall', 'sync_tag', 'hydro', 'quantiles', 'temporal', 'temporal_hydro', 'temporal_sync_tag'}
}
\value{
No return value, called to plot graphics.
}
\description{
Plot residuals of sync_model to enable check of model
}
\examples{
\donttest{
sync_model <- ssu1$sync_model

plotSyncModelHydros(sync_model)

plotSyncModelResids(sync_model, by = "overall")
plotSyncModelResids(sync_model, by = "quantiles")
plotSyncModelResids(sync_model, by = "sync_tag")
plotSyncModelResids(sync_model, by = "hydro")
plotSyncModelResids(sync_model, by = "temporal")
plotSyncModelResids(sync_model, by = "temporal_hydro")
plotSyncModelResids(sync_model, by = "temporal_sync_tag")

plotSyncModelCheck(sync_model, by = "hydro")
plotSyncModelCheck(sync_model, by = "sync_tag")
plotSyncModelCheck(sync_model, by = "sync_bin_sync")
plotSyncModelCheck(sync_model, by = "sync_bin_hydro")
}
}
