% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_rmarkdown.R
\name{yml_toc}
\alias{yml_toc}
\title{Specify Table of Contents options}
\usage{
yml_toc(
  .yml,
  toc = yml_blank(),
  toc_depth = yml_blank(),
  toc_title = yml_blank(),
  ...
)
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \verb{yml_*()} function}

\item{toc}{Logical. Use a Table of Contents?}

\item{toc_depth}{An integer. The depth of headers to use in the TOC. Note
that the actual YAML field is \code{toc-depth}.}

\item{toc_title}{The title of the TOC. Note that the actual YAML field is
\code{toc-title}.}

\item{...}{additional named R objects, such as characters or lists, to
transform into YAML}
}
\value{
a \code{yml} object
}
\description{
It's generally better to specify Table of Contents in the output function you
are using so you have a clearer idea of your options (e.g. \code{html_document(toc = TRUE, toc_float = TRUE)}). However, you can also generally specify at the
top level of YAML.
}
\examples{

yml() \%>\%
 yml_toc(toc = TRUE, toc_depth = 1, toc_title = "Article Outline")

}
\seealso{
Other yml: 
\code{\link{asis_yaml_output}()},
\code{\link{bib2yml}()},
\code{\link{draw_yml_tree}()},
\code{\link{has_field}()},
\code{\link{read_json}()},
\code{\link{use_yml_defaults}()},
\code{\link{use_yml_file}()},
\code{\link{use_yml}()},
\code{\link{yml_author}()},
\code{\link{yml_blogdown_opts}()},
\code{\link{yml_bookdown_opts}()},
\code{\link{yml_citations}()},
\code{\link{yml_clean}()},
\code{\link{yml_distill_opts}()},
\code{\link{yml_latex_opts}()},
\code{\link{yml_output}()},
\code{\link{yml_pagedown_opts}()},
\code{\link{yml_params}()},
\code{\link{yml_pkgdown}()},
\code{\link{yml_reference}()},
\code{\link{yml_replace}()},
\code{\link{yml_resource_files}()},
\code{\link{yml_rsconnect_email}()},
\code{\link{yml_rticles_opts}()},
\code{\link{yml_runtime}()},
\code{\link{yml_site_opts}()},
\code{\link{yml_vignette}()}
}
\concept{yml}
