% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fstrcapture.R
\name{fstrcapture}
\alias{fstrcapture}
\alias{gstrcapture}
\title{Capture string tokens into a data frame}
\usage{
fstrcapture(x, pattern, proto)

gstrcapture(x, pattern, proto)
}
\arguments{
\item{x}{
    A character vector in which to capture the tokens.
  }

\item{pattern}{
    The regular expression with the capture expressions.
  }

\item{proto}{
    A \code{data.frame} or S4 object that behaves like one. See details.
  }
}
\value{
A tabular data structure of the same type as proto, so typically a data.frame,
containing a column for each capture expression. The column types are
inherited from proto, as are the names unless the captures themselves are
named (in which case these are prioritised). Cases in x that do not match
the pattern have NA in every column. For \code{\link[=gstrcapture]{gstrcapture()}} there is an
additional column, \code{string_id}, which links the output to the relevant
element of the input vector.
}
\description{
\code{\link[=fstrcapture]{fstrcapture()}} is a more efficient alternative for \code{\link[=strcapture]{strcapture()}} when
using Perl-compatible regular expressions. It is underpinned by the
\code{\link[=regexpr]{regexpr()}} function. Whilst \code{\link[=fstrcapture]{fstrcapture()}} only returns the first
occurrence of the captures in a string, \code{\link[=gstrcapture]{gstrcapture()}}, built upon
\code{\link[=gregexpr]{gregexpr()}}, will return all.
}
\examples{

# from regexpr example -------------------------------------------------

# if named capture then pass names on irrespective of proto
notables <- c("  Ben Franklin and Jefferson Davis", "\tMillard Fillmore")
pattern <- "(?<first>[[:upper:]][[:lower:]]+) (?<last>[[:upper:]][[:lower:]]+)"
proto <- data.frame(a="", b="")
fstrcapture(notables, pattern, proto)
gstrcapture(notables, pattern, proto)

# from strcapture example ----------------------------------------------
# if unnamed capture then proto names used
x <- "chr1:1-1000"
pattern <- "(.*?):([[:digit:]]+)-([[:digit:]]+)"
proto <- data.frame(chr=character(), start=integer(), end=integer())
fstrcapture(x, pattern, proto)

# if no proto supplied then all captures treated as character
str(fstrcapture(x, pattern))
str(fstrcapture(x, pattern, proto))

}
\seealso{
\code{\link[=strcapture]{strcapture()}}.
}
