% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{padding}
\alias{padding}
\alias{margin}
\title{Margin and padding}
\usage{
padding(tag, all = NULL, top = NULL, right = NULL, bottom = NULL,
  left = NULL)

margin(tag, all = NULL, top = NULL, right = NULL, bottom = NULL,
  left = NULL)
}
\arguments{
\item{tag}{A tag element.}

\item{all, top, right, bottom, left}{A \link{responsive} argument.

For \strong{padding()}, one of \code{0:5} or \code{"auto"} specifying padding for one or
more sides of the tag element. 0 removes all inner space and 5 adds the
most space.

For \strong{margin()}, one of \code{-5:5} or \code{"auto"} specifying a margin for one or
more sides of the tag element. 0 removes all outer space, 5 adds the
most space, and negative values will consume space pulling the element in
that direction.}
}
\description{
Use the \code{margin()} and \code{padding()} utilities to change the margin or padding
of a tag element.  The margin of a tag element is the space outside and
around the tag element, its border, and its content.  The padding of a tag
element is the space between the tag element's border and its content or
child elements. All arguments default to \code{NULL}, in which case they are
ignored.
}
\examples{

### Centering an element

# In most modern browsers you want to horizontally center a tag element using
# the flex layout. Alternatively, you can horizontally center an element
# using `margin(.., right = "auto", left = "auto")`.

div(
  "Nam a sapien. Integer placerat tristique nisl.",
  style = "height: 100px; width: 200px;"
) \%>\%
  margin(top = 2, r = "auto", b = 2, l = "auto") \%>\%  # <-
  padding(3) \%>\%
  background("indigo")

### Building an inline form

# Inline form elements automatically use the flex layout providing you a
# means of creating condensed sets of inputs. However, you may need to adjust
# the spacing of the form's child elements.

# Here is an inline form without any additional spacing applied.

formInput(
  id = "form1",
  inline = TRUE,
  textInput(
    id = "name",
    placeholder = "Full name"
  ),
  groupTextInput(
    id = "username",
    left = "@",
    placeholder = "Username"
  ),
  checkboxInput(
    id = "remember",
    choice = "Remember me"
  ),
  formSubmit("Login", "login")
)

# Without any adjustments the layout is not great. But, with some styling we
# can make this form sparkle. Notice we are also adjusting the default submit
# button added to the form input.

formInput(
  id = "form2",
  inline = TRUE,
  textInput(
    id = "name",
    placeholder = "Full name"
  ) \%>\%
    margin(r = c(sm = 2), b = 2),  # <-
  groupTextInput(
    id = "username",
    left = "@",
    placeholder = "Username"
  ) \%>\%
    margin(r = c(sm = 2), b = 2),  # <-
  checkboxInput(
    id = "remember",
    choice = "Remember me"
  ) \%>\%
    margin(r = c(sm = 2), b = 2),  # <-
  formSubmit(
    label = "Login",
    value = "login"
  ) \%>\%
    margin(b = 2)  # <-
)

}
\seealso{
Other design utilities: \code{\link{active}},
  \code{\link{affix}}, \code{\link{background}},
  \code{\link{border}}, \code{\link{display}},
  \code{\link{float}}, \code{\link{font}},
  \code{\link{height}}, \code{\link{scroll}},
  \code{\link{shadow}}, \code{\link{width}}
}
\concept{design utilities}
